/*
 *	HP Convex Division
 *	RBD/PAE
 *
 *	$Id: shm.locks.hpux.c,v 6.1 96/11/22 13:35:11 nevin Rel $
 *
 *	Function:	- PA-RISC memory lock routines
 *			- lock address must be on a 16-byte boundary
 *			  (e.g. typedef int hplock_t[4];)
 *			- uses asm routines: _hp_synch() and _hp_ldcws32()
 *			- inline them to remove function call overhead
 */

#include <errno.h>
#include <sys/types.h>
#include <sys/time.h>

#define POLLCOUNT	1000000			/* # loops before usleep() */
#define USLEEP		100			/* usleep() delay */

/*
 * global variables
 */
int			_lock_poll = POLLCOUNT;	/* # loops before usleep() */
int			_lock_delay = USLEEP;	/* usleep() delay */


/*
 *	_hp_lockinit
 *
 *	Function:	- initialize a lock (reset to 1)
 *			- only first integer used
 *	Accepts:	- ptr lock
 */
void
_hp_lockinit(lock)

volatile int		*lock;

{
	*lock = 1;
}

/*
 *	_hp_lock
 *
 *	Function:	- grab a lock
 *			- wait till it's 1, then load-and-clear
 *			- adjust poll count and sleep time to suit taste
 *			- only first integer used
 *	Accepts:	- ptr lock
 */
void
_hp_lock(lock)

volatile int		*lock;

{
	register int	count;

	while (1) {
		for (count = 0; *lock == 0; ) {
			if (++count == _lock_poll) {
				count = 0;
				microsleep(_lock_delay);
			}
		}

		if (_hp_ldcws32(lock)) return;
	}
}


/*
 *	_hp_trylock
 *
 *	Function:	- try grab a lock
 *			- if it's 1, then load-and-clear
 *			- only first integer used
 *	Accepts:	- ptr lock
 *	Returns:	- 0 if lock obtained else 1
 */
int
_hp_trylock(lock)

volatile int		*lock;

{
	return((*lock && _hp_ldcws32(lock)) ? 0 : 1);
}

/*
 *	_hp_unlock
 *
 *	Function:	- release a lock
 *			- only first integer used
 *	Accepts:	- ptr lock
 */
void
_hp_unlock(lock)

volatile int		*lock;

{
	_hp_synch();
	*lock = 1;
}
