/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD/JRV
 *
 *	$Id: scatterv.c,v 6.1 96/11/23 22:54:02 nevin Rel $
 *
 *	Function:	- scatter varying len. buffers from root in rank order
 *	Accepts:	- send buffer
 *			- send counts
 *			- displacements
 *			- send datatype
 *			- recv buffer
 *			- recv count
 *			- recv datatype
 *			- root
 *			- communicator
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <app_mgmt.h>
#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <rpisys.h>

int
MPI_Scatterv(sbuf, scounts, disps, sdtype, rbuf, rcount, rdtype, root, comm)

void			*sbuf;
int			*scounts;
int			*disps;
MPI_Datatype		sdtype;
void			*rbuf;
int			rcount;
MPI_Datatype		rdtype;
int			root;
MPI_Comm		comm;

{
	int		i;			/* favourite index */
	int		rank;			/* my rank */
	int		size;			/* group size */
	int		err;			/* error code */
	char		*ptmp;			/* temp. buffer */
	MPI_Aint	extent;			/* datatype extent */
	MPI_Status	status;			/* recv status */
	struct _gps	*p;			/* favourite pointer */

	lam_initerr();
	lam_setfunc(BLKMPISCATTERV);
/*
 * Check for invalid arguments.
 */
	if ((comm == MPI_COMM_NULL) || LAM_IS_INTER(comm)) {
		return(lam_errfunc(comm, BLKMPISCATTERV,
				lam_mkerr(MPI_ERR_COMM, 0)));
	}

	MPI_Comm_rank(comm, &rank);
	MPI_Comm_size(comm, &size);

	if ((root >= size) || (root < 0)) {
		return(lam_errfunc(comm, BLKMPISCATTERV,
				lam_mkerr(MPI_ERR_ROOT, 0)));
	}

	if ((rank == root) && (disps == 0)) {
		return(lam_errfunc(comm, BLKMPISCATTERV,
				lam_mkerr(MPI_ERR_ARG, 0)));
	}

	if ((root == rank && sdtype == MPI_DATATYPE_NULL)
			|| (rdtype == MPI_DATATYPE_NULL)) {
		return(lam_errfunc(comm, BLKMPISCATTERV,
				lam_mkerr(MPI_ERR_TYPE, 0)));
	}

	if ((rcount < 0) || (rank == root && scounts == 0)) {
		return(lam_errfunc(comm, BLKMPISCATTERV,
				lam_mkerr(MPI_ERR_COUNT, 0)));
	}

	LAM_TRACE(lam_tr_cffstart(BLKMPISCATTERV));
/*
 * Remember required parameters.
 */
	p = &(comm->c_group->g_procs[root]->p_gps);

	lam_setparam(BLKMPISCATTERV, root | (p->gps_grank << 16),
				(p->gps_node << 16) | p->gps_idx);
/*
 * Switch to collective communicator.
 */
	lam_mkcoll(comm);
/*
 * If not root, receive data.
 */
	if (rank != root) {
		err = MPI_Recv(rbuf, rcount, rdtype,
					root, BLKMPISCATTERV, comm, &status);
		lam_mkpt(comm);

		if (err != MPI_SUCCESS) {
			return(lam_errfunc(comm, BLKMPISCATTERV, err));
		}

		LAM_TRACE(lam_tr_cffend(BLKMPISCATTERV,
						root, comm, rdtype, rcount));
		
		lam_resetfunc(BLKMPISCATTERV);
		return(MPI_SUCCESS);
	}
/*
 * I am the root, loop sending data.
 */
	MPI_Type_extent(sdtype, &extent);

	for (i = 0; i < size; ++i) {

		ptmp = ((char *) sbuf) + (extent * disps[i]);
/*
 * simple optimization
 */
		if (i == rank) {
			err = lam_dtsndrcv(ptmp, scounts[i], sdtype, rbuf,
					rcount, rdtype, BLKMPISCATTERV,	comm);
		} else {
			err = MPI_Send(ptmp, scounts[i], sdtype,
					i, BLKMPISCATTERV, comm);
		}

		if (err != MPI_SUCCESS) {
			lam_mkpt(comm);
			return(lam_errfunc(comm, BLKMPISCATTERV, err));
		}
	}

	lam_mkpt(comm);

	LAM_TRACE(lam_tr_cffend(BLKMPISCATTERV, root, comm, rdtype, rcount));
	
	lam_resetfunc(BLKMPISCATTERV);
	return(MPI_SUCCESS);
}
