/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD/JRV
 *
 *	$Id: scatter.c,v 6.1 96/11/23 22:54:01 nevin Rel $
 *
 *	Function:	- scatters buffers from root in process rank order
 *	Accepts:	- send buffer
 *			- send count
 *			- send datatype
 *			- recv buffer
 *			- recv count
 *			- recv datatype
 *			- root
 *			- communicator
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <app_mgmt.h>
#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <rpisys.h>

int
MPI_Scatter(sbuf, scount, sdtype, rbuf, rcount, rdtype, root, comm)

void			*sbuf;
int			scount;
MPI_Datatype		sdtype;
void			*rbuf;
int			rcount;
MPI_Datatype		rdtype;
int			root;
MPI_Comm		comm;

{
	int		i;			/* favourite index */
	int		rank;			/* my rank */
	int		size;			/* group size */
	int		err;			/* error code */
	char		*ptmp;			/* temp. buffer */
	MPI_Aint	incr;			/* buffer increments */
	MPI_Status	status;			/* recv status */
	struct _gps	*p;			/* favourite pointer */

	lam_initerr();
	lam_setfunc(BLKMPISCATTER);
/*
 * Check for invalid arguments.
 */
	if ((comm == MPI_COMM_NULL) || LAM_IS_INTER(comm)) {
		return(lam_errfunc(comm, BLKMPISCATTER,
				lam_mkerr(MPI_ERR_COMM, 0)));
	}

	MPI_Comm_rank(comm, &rank);
	MPI_Comm_size(comm, &size);

	if ((root >= size) || (root < 0)) {
		return(lam_errfunc(comm, BLKMPISCATTER,
				lam_mkerr(MPI_ERR_ROOT, 0)));
	}

	if ((root == rank && sdtype == MPI_DATATYPE_NULL)
			|| (rdtype == MPI_DATATYPE_NULL)) {
		return(lam_errfunc(comm, BLKMPISCATTER,
				lam_mkerr(MPI_ERR_TYPE, 0)));
	}

	if ((rcount < 0) || (rank == root && scount < 0)) {
		return(lam_errfunc(comm, BLKMPISCATTER,
				lam_mkerr(MPI_ERR_COUNT, 0)));
	}

	LAM_TRACE(lam_tr_cffstart(BLKMPISCATTER));
/*
 * Remember required parameters.
 */
	p = &(comm->c_group->g_procs[root]->p_gps);

	lam_setparam(BLKMPISCATTER, root | (p->gps_grank << 16),
				(p->gps_node << 16) | p->gps_idx);
/*
 * Switch to collective communicator.
 */
	lam_mkcoll(comm);
/*
 * If not root, receive data.
 */
	if (rank != root) {
		err = MPI_Recv(rbuf, rcount, rdtype,
					root, BLKMPISCATTER, comm, &status);
		lam_mkpt(comm);

		if (err != MPI_SUCCESS) {
			return(lam_errfunc(comm, BLKMPISCATTER, err));
		}

		LAM_TRACE(lam_tr_cffend(BLKMPISCATTER,
						root, comm, rdtype, rcount));
		
		lam_resetfunc(BLKMPISCATTER);
		return(MPI_SUCCESS);
	}
/*
 * I am the root, loop sending data.
 */
	MPI_Type_extent(sdtype, &incr);
	incr *= scount;

	for (i = 0, ptmp = (char *) sbuf; i < size; ++i, ptmp += incr) {
/*
 * simple optimization
 */
		if (i == rank) {
			err = lam_dtsndrcv(ptmp, scount, sdtype, rbuf,
					rcount, rdtype, BLKMPISCATTER, comm);
		} else {
			err = MPI_Send(ptmp, scount, sdtype,
					i, BLKMPISCATTER, comm);
		}

		if (err != MPI_SUCCESS) {
			lam_mkpt(comm);
			return(lam_errfunc(comm, BLKMPISCATTER, err));
		}
	}

	lam_mkpt(comm);

	LAM_TRACE(lam_tr_cffend(BLKMPISCATTER, root, comm, rdtype, rcount));

	lam_resetfunc(BLKMPISCATTER);
	return(MPI_SUCCESS);
}
