/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	NJN
 *
 *	$Id: rpi.mop.c,v 6.1 96/11/22 13:35:08 nevin Rel $
 *
 *	Function:	- clean up persistent RPI state
 */

#include <stdlib.h>

/*
 * public functions
 */
void			_rpi_mop_up();


#if defined(RPI_SHM) && defined(SHM_SGI)

extern char		*killname();

void
_rpi_mop_up()

{
	char		syscmd[256];		/* system command */
	char		*kill;			/* kill filename */
/*
 * Remove all arena files.
 */
	kill = killname();
	if (kill == 0) return;

	sprintf(syscmd, "%s %s-a*.*", RM, kill);
	system(syscmd);

	free(kill);
}

#elif defined(RPI_SHM) && defined(SHM_SYSV)

extern void		_sysv_slop_clean();

void
_rpi_mop_up()

{
	_sysv_slop_clean();
}

#else

void
_rpi_mop_up()

{
}

#endif
