/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	NJN
 *
 *	$Id: portopen.c,v 6.1 96/11/22 13:35:07 nevin Rel $
 *
 *	Function:	- open an MPI port
 *	Accepts:	- info
 *			- port name (out)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <sfh.h>

#include <string.h>

#include <app_mgmt.h>
#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <rpisys.h>
#include <terror.h>


int
MPI_Port_open(info, port_name)

MPI_Info		info;
char			*port_name;

{
	struct _port	port;			/* new port */
	int		port_num;		/* port number */

	lam_initerr();
	lam_setfunc(BLKMPIPORTOPEN);
/*
 * Open a port.
 */
	if ((port_num = lam_port_open()) < 0) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPIPORTOPEN,
				lam_mkerr(MPI_ERR_OTHER, errno)));
	}
	port.prt_num = port_num;
/*
 * Add port to list of open ports.
 */
	sprintf(port.prt_name, "n%d:i%d:%d", lam_myproc->p_gps.gps_node,
		lam_myproc->p_gps.gps_idx, port_num);
	
	if (al_find(lam_ports, &port) != 0) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPIPORTOPEN,
					lam_mkerr(MPI_ERR_INTERN, 0)));
	}
	if (al_insert(lam_ports, &port) == 0) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPIPORTOPEN,
					lam_mkerr(MPI_ERR_OTHER, errno)));
	}
/*
 * Set return value.
 */
	strcpy(port_name, port.prt_name);
	
        lam_resetfunc(BLKMPIPORTOPEN);
	return(MPI_SUCCESS);
}
