/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: packsize.c,v 6.1 96/11/23 22:53:40 nevin Rel $
 *
 *	Function:	- get size needed to pack data
 *	Accepts:	- count
 *			- datatype
 *			- communicator
 *			- ptr to size
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>

int
MPI_Pack_size(count, dtype, comm, psize)

int			count;
MPI_Datatype		dtype;
MPI_Comm		comm;
int			*psize;

{
	lam_initerr();
	lam_setfunc(BLKMPIPACKSIZE);
/*
 * Check the arguments.
 */
	if (comm == MPI_COMM_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIPACKSIZE, lam_mkerr(MPI_ERR_COMM, 0)));
	}

	if (count < 0) {
		return(lam_errfunc(comm,
			BLKMPIPACKSIZE, lam_mkerr(MPI_ERR_COUNT, 0)));
	}

	if (dtype == MPI_DATATYPE_NULL) {
		return(lam_errfunc(comm,
			BLKMPIPACKSIZE, lam_mkerr(MPI_ERR_TYPE, 0)));
	}

	if (psize == 0) {
		return(lam_errfunc(comm,
			BLKMPIPACKSIZE, lam_mkerr(MPI_ERR_ARG, 0)));
	}
/*
 * Return the size.
 */
	*psize = count * dtype->dt_size;

	lam_resetfunc(BLKMPIPACKSIZE);
	return(MPI_SUCCESS);
}
