/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	NJN
 *
 *	$Id: namepub.c,v 6.1 96/11/22 13:35:04 nevin Rel $
 *
 *	Function:	- publish a port/service pair
 *	Accepts:	- port name
 *			- info
 *			- service name
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <lam_config.h>

#include <errno.h>

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <rpisys.h>
#include <terror.h>
#include <trreq.h>


int
MPI_Name_publish(port_name, info, service_name)

char			*port_name;
MPI_Info		info;
char			*service_name;

{
	int4		id;			/* name publishing ID */
	
	lam_initerr();
	lam_setfunc(BLKMPINAMEPUB);
/*
 * Check arguments.
 */
	if (port_name == 0 || service_name == 0) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPINAMEPUB,
				lam_mkerr(MPI_ERR_ARG, 0)));
	}
/*
 * Publish name.
 */
	id = (int4) ((lam_myproc->p_gps.gps_pid << 16)
			| lam_myproc->p_gps.gps_node);
	
	if (lam_rtrnamepub(0, id, service_name, port_name)) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPINAMEPUB,
				lam_mkerr(MPI_ERR_SERVICE, errno))); 
	}

        lam_resetfunc(BLKMPINAMEPUB);
	return(MPI_SUCCESS);
}
