/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	GDB
 *
 *	$Id: mpil_signal.c,v 6.1 96/11/23 22:53:28 nevin Rel $
 *
 *	Function:	- delivers a signal to a process
 *	Accepts:	- communicator
 *			- process rank
 *			- signal number
 */

#include <blktype.h>
#include <lam_ksignal.h>
#include <mpi.h>
#include <mpisys.h>
#include <portable.h>
#include <preq.h>
#include <terror.h>

int
MPIL_Signal(comm, rank, signo)

MPI_Comm		comm;
int			rank;
int			signo;

{
	int		err;		/* MPI error code */
	int		nid;		/* process's node ID */
	int		pid;		/* process ID */

	lam_initerr();
	lam_setfunc(BLKMPILSIGNAL);

	if (comm == MPI_COMM_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			lam_getfunc(), lam_mkerr(MPI_ERR_COMM, 0)));
	}

	if ((rank == MPI_ANY_SOURCE) || (rank < 0)
		|| (LAM_IS_INTRA(comm) && rank >= comm->c_group->g_nprocs)
		|| (LAM_IS_INTER(comm) && rank >= comm->c_rgroup->g_nprocs)) {
		
		return(lam_errfunc(comm, lam_getfunc(), 
					lam_mkerr(MPI_ERR_RANK, 0)));
	}

	err = MPIL_Comm_gps(comm, rank, &nid, &pid);

	if (err != MPI_SUCCESS) {
		return(lam_errfunc(comm, BLKMPILSIGNAL, err));
	}

	if (rpdoom((int4) nid, (int4) SELECT_PID, (int4) pid, (int4) signo)) {
		return(lam_errfunc(comm, lam_getfunc(),
					lam_mkerr(MPI_ERR_OTHER, errno)));
	}

	lam_resetfunc(BLKMPILSIGNAL);
	return(MPI_SUCCESS);
}
