/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD/GDB
 *
 *	$Id: lamsend.c,v 6.1 96/11/23 22:53:15 nevin Rel $
 *
 *	Function:	- shared code for send functions
 */

#include <mpi.h>
#include <mpisys.h>
#include <mpitrace.h>
#include <rpisys.h>
#include <typical.h>

/*
 * public functions
 */
int			lam_send();
int			lam_isend();

/*
 *	lam_send
 *
 *	Function:	- send a blocking MPI message
 *	Accepts:	- MPI send args
 *			- request type
 *	Returns:	- MPI_SUCCESS or error code
 */
int
lam_send(buf, count, dtype, dest, tag, comm, reqtype)

void			*buf;
int			count;
MPI_Datatype		dtype;
int			dest;
int			tag;
MPI_Comm		comm;
int			reqtype;

{
	int		err;
	int		fl_trace;		/* do tracing? */
	int		req_err;		/* recoverable error */
	int		seqnum;			/* message sequence number */
	struct _req	req_storage;
	MPI_Request	req;
	double		startt;			/* start time */
	double		finisht;		/* finish time */
/*
 * Handle the trivial cases.
 */
	if (tag == MPI_ANY_TAG) return(lam_mkerr(MPI_ERR_TAG, 0));

	if (dest == MPI_ANY_SOURCE) return(lam_mkerr(MPI_ERR_RANK, 0));

	if (dest == MPI_PROC_NULL) return(MPI_SUCCESS);

	if ((fl_trace = LAM_TRACE_TOP())) {
		startt = MPI_Wtime();
		_kio.ki_blktime = 0.0;
	}

	req = &req_storage;
	err = _mpi_req_build(buf, count, dtype, dest, tag, comm, reqtype, &req);
	if (err != MPI_SUCCESS) return(err);

	req->rq_marks |= LAM_RQFBLKTYPE;

	err = _mpi_req_start(req);
	if (err != MPI_SUCCESS) return(err);

	_mpi_req_add_m(req);
	_mpi_req_blkclr_m();
	_mpi_req_blkset_m(req);

	err = _mpi_req_advance();
	if (err != MPI_SUCCESS) return(err);

	req_err = req->rq_status.MPI_ERROR;
	seqnum = req->rq_seq;

	_mpi_req_rem_m(req);

	err = _mpi_req_destroy(&req);
	if (err != MPI_SUCCESS) return(err);
/*
 * Generate a trace.
 */
	if (fl_trace) {
		finisht = MPI_Wtime();

		lam_tr_msg(TRTOUTPUT, startt,
				LAM_S2US(finisht - startt - _kio.ki_blktime),
				LAM_S2US(_kio.ki_blktime), dest, tag,
				comm, dtype, count, 0, 0, seqnum, reqtype);
	}

	return(req_err);
}

/*
 *	lam_isend
 *
 *	Function:	- send a non-blocking MPI message
 *	Accepts:	- MPI isend args
 *			- request type
 *	Returns:	- MPI_SUCCESS or error code
 */
int
lam_isend(buf, count, dtype, dest, tag, comm, preq, reqtype)

void			*buf;
int			count;
MPI_Datatype		dtype;
int			dest;
int			tag;
MPI_Comm		comm;
MPI_Request		*preq;
int			reqtype;

{
	int		err;
/*
 * Handle the trivial cases.
 */
	if (tag == MPI_ANY_TAG) return(lam_mkerr(MPI_ERR_TAG, 0));

	if (dest == MPI_ANY_SOURCE) return(lam_mkerr(MPI_ERR_RANK, 0));

	*preq = MPI_REQUEST_NULL;
	err = _mpi_req_build(buf, count, dtype, dest, tag, comm,
			reqtype, preq);
	if (err != MPI_SUCCESS) return(err);

	err = _mpi_req_start(*preq);
	if (err != MPI_SUCCESS) return(err);

	_mpi_req_add_m(*preq);
	_mpi_req_blkclr_m();

	err = _mpi_req_advance();

	return(err);
}
