/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD/NJN
 *
 *	$Id: laminited.c,v 6.1 96/11/23 22:53:04 nevin Rel $
 *
 *	Function:	- test if MPI has been initialized/finalized
 */

#include <stdio.h>
#include <unistd.h>

#include <mpi.h>
#include <mpisys.h>
#include <terror.h>

/*
 * global variables
 */
int 			lam_flinit = 0;
int 			lam_flfinal = 0;

/*
 *	lam_inited
 *
 *	Function:	- check if MPI has been initialized
 *	Returns:	- TRUE or FALSE
 */
int
lam_inited()

{
/*
 * Using _kio_ki_pid works when a process is forked.
 *
 * return(_kio.ki_pid == getpid());
 */
	return(lam_flinit);
}

/*
 *	lam_finalized
 *
 *	Function:	- check if MPI has been finalized
 *	Returns:	- TRUE or FALSE
 */
int
lam_finalized()

{
	return(lam_flfinal);
}

/*
 *	lam_initerr
 *
 *	Function:	- if MPI not initialized, abort as an error
 */
void
lam_initerr()

{
	if (lam_flinit == 0) {
		LAMSetLastError(EMPINOINIT);
		fprintf(stderr, "MPI error: process not initialized\n");
		exit(LAM_EEXIT);
	}
}
