/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: lamcid.c,v 6.1 96/11/23 22:52:54 nevin Rel $
 *
 *	Function:	- manage context identifiers
 *			- trivial version
 */

#include <typical.h>
#include <mpi.h>
#include <mpisys.h>

/*
 * static variables
 */
static int		topcid = 0;		/* top unused context ID */

/*
 *	lam_getcid
 *
 *	Function:	- get next available context ID
 *	Returns:	- context ID or LAMERROR
 */
int
lam_getcid()

{
	return( ((topcid < 0) || (topcid > MPI_MAX_CID)) ? LAMERROR : topcid);
}

/*
 *	lam_setcid
 *
 *	Function:	- set highest used context ID
 *	Accepts:	- context ID
 */
void
lam_setcid(cid)

int			cid;

{
	topcid = cid + 1;
}

/*
 *	lam_rmcid
 *
 *	Function:	- deallocate (remove) a context ID
 *	Accepts:	- context ID
 */
void
lam_rmcid(cid)

int			cid;

{
}

/*
 *	lam_nukecids
 *
 *	Function:	- deallocate all context IDs (cleanup)
 */
void
lam_nukecids()

{
	topcid = 0;
}
