/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	NJN
 *
 *	$Id: infogetnkeys.c,v 6.1 96/11/22 13:34:57 nevin Rel $
 *
 *	Function:	- get number of keys in an info object
 *	Accepts:	- info
 *			- number of keys (out)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <string.h>

#include <all_list.h>
#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>


int
MPI_Info_get_nkeys(info, nkeys)

MPI_Info		info;
int			*nkeys;

{
        lam_initerr();
	lam_setfunc(BLKMPIINFONKEYS);
	
	if (info == 0) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPIINFONKEYS,
					lam_mkerr(MPI_ERR_ARG, 0)));
	}

	*nkeys = al_count((LIST *) info);

        lam_resetfunc(BLKMPIINFONKEYS);
	return(MPI_SUCCESS);
}
