/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	NJN
 *
 *	$Id: infodup.c,v 6.1 96/11/22 13:34:55 nevin Rel $
 *
 *	Function:	- duplicate an info object
 *	Accepts:	- info
 *			- duplicate info (inout)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <string.h>

#include <all_list.h>
#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>


int
MPI_Info_dup(info, newinfo)

MPI_Info		info;
MPI_Info		*newinfo;

{
	struct _info	*p;			/* key/value pair */
	int		err;			/* error code */
	
        lam_initerr();
	lam_setfunc(BLKMPIINFODUP);
	
	if (info == 0) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPIINFODUP,
					lam_mkerr(MPI_ERR_ARG, 0)));
	}

	err = MPI_Info_create(newinfo);
	if (err != MPI_SUCCESS) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPIINFODUP, err));
	}
/*
 * Duplicate all the entries.
 */
	for (p = al_top((LIST *) info); p; p = al_next((LIST *) info, p)) {
		err = MPI_Info_set(*newinfo, p->info_key, p->info_value);
		if (err != MPI_SUCCESS) {
			return(lam_errfunc(MPI_COMM_WORLD,
						BLKMPIINFODUP, err));
		}
	}

        lam_resetfunc(BLKMPIINFODUP);
	return(MPI_SUCCESS);
}
