/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	NJN
 *
 *	$Id: infodel.c,v 6.1 96/11/22 13:34:55 nevin Rel $
 *
 *	Function:	- delete info key and associated value
 *	Accepts:	- info (inout)
 *			- key
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <string.h>

#include <all_list.h>
#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>


int
MPI_Info_delete(info, key)

MPI_Info		info;
char			*key;

{
	struct _info	search;			/* search element */
	struct _info	*found;			/* found key/value pair */
	int		key_len;		/* key length */

        lam_initerr();
	lam_setfunc(BLKMPIINFODEL);
	
	if (info == 0) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPIINFODEL,
					lam_mkerr(MPI_ERR_ARG, 0)));
	}

	key_len = strlen(key);
	if (key_len == 0 || key_len > MPI_INFO_MAX_KEYLEN) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPIINFODEL,
					lam_mkerr(MPI_ERR_ARG, 0)));
	}

	strcpy(search.info_key, key);

	if ((found = al_find((LIST *) info, &search))) {
		if (al_delete((LIST *) info, found) < 0) {
			return(lam_errfunc(MPI_COMM_WORLD, BLKMPIINFODEL,
						lam_mkerr(MPI_ERR_INTERN, 0)));
		}
	} else {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPIINFODEL,
					lam_mkerr(MPI_ERR_INFO_NOKEY, 0)));
	}

        lam_resetfunc(BLKMPIINFODEL);
	return(MPI_SUCCESS);
}
