/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	NJN
 *
 *	$Id: infocreate.c,v 6.1 96/11/22 13:34:54 nevin Rel $
 *
 *	Function:	- info object constructor
 *	Accepts:	- info (returned)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <all_list.h>
#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <terror.h>

/*
 * private functions
 */
static int		info_key_cmp();


int
MPI_Info_create(info)

MPI_Info		*info;

{
        lam_initerr();
	lam_setfunc(BLKMPIINFOCREATE);

	if (info == 0) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPIINFOCREATE,
					lam_mkerr(MPI_ERR_ARG, 0)));
	}

	*((LIST **) info) = al_init(sizeof(struct _info), info_key_cmp);

	if (*info == 0) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPIINFOCREATE,
					lam_mkerr(MPI_ERR_OTHER, errno)));
	}

        lam_resetfunc(BLKMPIINFOCREATE);
	return(MPI_SUCCESS);
}

/*
 *	info_key_cmp
 *
 *	Function:	- compare two info entries by key
 *	Accepts:	- ptr to two entries
 *	Returns:	- string comparison of keys
 */
static int
info_key_cmp(a, b)

struct _info		*a;
struct _info		*b;

{
	return(strcmp(a->info_key, b->info_key));
}
