/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: gtranks.c,v 6.1 96/11/23 22:52:23 nevin Rel $
 *
 *	Function:	- get process ranks in a second group
 *	Accepts:	- first group
 *			- # of processes
 *			- array of ranks in first group
 *			- second group
 *			- array of ranks in second group (returned values)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>

int
MPI_Group_translate_ranks(g1, n, r1, g2, r2)

MPI_Group		g1;
int			n;
int			*r1;
MPI_Group		g2;
int			*r2;

{
	int		i, j;			/* favourite indices */
	int		rank;			/* process rank */
	struct _proc	**p1, **p2;		/* gps pointers */

	lam_initerr();
	lam_setfunc(BLKMPIGROUPTRANKS);
/*
 * Check given arguments.
 */
	if ((g1 == MPI_GROUP_NULL) || (g2 == MPI_GROUP_NULL)) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIGROUPTRANKS, lam_mkerr(MPI_ERR_GROUP, 0)));
	}

	if (n == 0) {
		lam_resetfunc(BLKMPIGROUPTRANKS);
		return(MPI_SUCCESS);
	}

	if ((n < 0) || (r1 == 0) || (r2 == 0)) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIGROUPTRANKS, lam_mkerr(MPI_ERR_ARG, 0)));
	}
/*
 * Loop over the processes, translating their ranks.
 */
	for (i = 0; i < n; ++i) {
		rank = r1[i];

		if ((rank >= 0) && (rank < g1->g_nprocs)) {

			p1 = g1->g_procs + rank;
			p2 = g2->g_procs;

			for (j = 0; j < g2->g_nprocs; ++j, ++p2) {
				if (*p1 == *p2) break;
			}

			r2[i] = (j < g2->g_nprocs) ? j : MPI_UNDEFINED;
		}
		else {
			r2[i] = MPI_UNDEFINED;
		}
	}

	lam_resetfunc(BLKMPIGROUPTRANKS);
	return(MPI_SUCCESS);
}
