/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: gsize.c,v 6.1 96/11/23 22:52:22 nevin Rel $
 *
 *	Function:	- return the size of the group
 *	Accepts:	- group
 *			- ptr to size (returned value)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>

int
MPI_Group_size(group, psize)

MPI_Group		group;
int			*psize;

{
	lam_initerr();
	lam_setfunc(BLKMPIGROUPSIZE);

	if ((group != MPI_GROUP_NULL) && (psize != 0)) {
		*psize = group->g_nprocs;
	}
	else if (group == MPI_GROUP_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIGROUPSIZE, lam_mkerr(MPI_ERR_GROUP, 0)));
	}
	else {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIGROUPSIZE, lam_mkerr(MPI_ERR_ARG, 0)));
	}

	lam_resetfunc(BLKMPIGROUPSIZE);
	return(MPI_SUCCESS);
}
