/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: graphmap.c,v 6.1 96/11/23 22:52:14 nevin Rel $
 *
 *	Function:	- map processes to graph coordinates
 *	Accepts:	- old communicator
 *			- # processes
 *			- node index array
 *			- array of edges
 *			- ptr caller's new rank
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>

int
MPI_Graph_map(comm, nnodes, index, edges, pnewrank)

MPI_Comm		comm;
int			nnodes;
int			*index;
int			*edges;
int			*pnewrank;

{
	int		errcode;
	int		myrank;

	lam_initerr();
	lam_setfunc(BLKMPIGRAPHMAP);
/*
 * Check the arguments.
 */
	if (comm == MPI_COMM_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIGRAPHMAP, lam_mkerr(MPI_ERR_COMM, 0)));
	}

	if (LAM_IS_INTER(comm)) {
		return(lam_errfunc(comm,
			BLKMPIGRAPHMAP, lam_mkerr(MPI_ERR_COMM, 0)));
	}

	if ((nnodes < 1) || (index == 0) || (edges == 0) || (pnewrank == 0)) {
		return(lam_errfunc(comm,
			BLKMPIGRAPHMAP, lam_mkerr(MPI_ERR_ARG, 0)));
	}
/*
 * Assign new rank.
 */
	errcode = MPI_Comm_rank(comm, &myrank);
	if (errcode != MPI_SUCCESS) {
		return(lam_errfunc(comm, BLKMPIGRAPHMAP, errcode));
	}

	*pnewrank =
		((myrank < 0) || (myrank >= nnodes)) ? MPI_UNDEFINED : myrank;

	lam_resetfunc(BLKMPIGRAPHMAP);
	return(MPI_SUCCESS);
}
