/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: graphcreate.c,v 6.1 96/11/23 22:52:09 nevin Rel $
 *
 *	Function:	- create a communicator with graph mapping
 *	Accepts:	- old communicator
 *			- # nodes
 *			- node index array
 *			- array of edges
 *			- rank reordering flag
 *			- ptr new communicator
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <stdlib.h>

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <terror.h>

int
MPI_Graph_create(comm, nnodes, index, edges, reorder, pnewcomm)

MPI_Comm		comm;
int			nnodes;
int			*index;
int			*edges;
int			reorder;
MPI_Comm		*pnewcomm;

{
	MPI_Comm	newcomm;
	MPI_Group	newgroup;
	int		nedges;
	int		size;
	int		err;
	int		range[1][3];
	int		i;
	int		*p;

	lam_initerr();
	lam_setfunc(BLKMPIGRAPHCREATE);
/*
 * Check the arguments.
 */
	if (comm == MPI_COMM_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIGRAPHCREATE, lam_mkerr(MPI_ERR_COMM, 0)));
	}

	if (LAM_IS_INTER(comm)) {
		return(lam_errfunc(comm,
			BLKMPIGRAPHCREATE, lam_mkerr(MPI_ERR_COMM, 0)));
	}

	if ((nnodes < 1) || (index == 0) || (edges == 0) || (pnewcomm == 0)) {
		return(lam_errfunc(comm,
			BLKMPIGRAPHCREATE, lam_mkerr(MPI_ERR_ARG, 0)));
	}

	LAM_TRACE(lam_tr_cffstart(BLKMPIGRAPHCREATE));
/*
 * Create the group for the new communicator.
 */
	err = MPI_Comm_size(comm, &size);
	if (err != MPI_SUCCESS) {
		return(lam_errfunc(comm, BLKMPIGRAPHCREATE, err));
	}

	if (nnodes > size) {
		return(lam_errfunc(comm, BLKMPIGRAPHCREATE,
				lam_mkerr(MPI_ERR_ARG, 0)));
	}

	if (nnodes == size) {
		err = MPI_Comm_group(comm, &newgroup);
	} else {
		range[0][0] = 0;
		range[0][1] = nnodes - 1;
		range[0][2] = 1;
		err = MPI_Group_range_incl(comm->c_group, 1, range, &newgroup);
	}

	if (err != MPI_SUCCESS) {
		return(lam_errfunc(comm, BLKMPIGRAPHCREATE, err));
	}
/*
 * Create the new communicator.
 */
	err = MPI_Comm_create(comm, newgroup, pnewcomm);
	if (err != MPI_SUCCESS) {
		MPI_Group_free(&newgroup);
		return(lam_errfunc(comm, BLKMPIGRAPHCREATE, err));
	}
/*
 * Fill the communicator with topology information. 
 */
	newcomm = *pnewcomm;
	if (newcomm != MPI_COMM_NULL) {
		newcomm->c_topo_type = MPI_GRAPH;
		newcomm->c_topo_nprocs = nnodes;
		newcomm->c_topo_nedges = nedges = index[nnodes - 1];

		newcomm->c_topo_index = (int *)
			malloc((unsigned) (nnodes + nedges) * sizeof(int));
		if (newcomm->c_topo_index == 0) {
			return(lam_errfunc(comm, BLKMPIGRAPHCREATE,
					lam_mkerr(MPI_ERR_OTHER, errno)));
		}
		newcomm->c_topo_edges = newcomm->c_topo_index + nnodes;

		for (i = 0, p = newcomm->c_topo_index; i < nnodes; ++i, ++p) {
			*p = *index++;
		}

		for (i = 0, p = newcomm->c_topo_edges; i < nedges; ++i, ++p) {
			*p = *edges++;
		}
	}

	err = MPI_Group_free(&newgroup);
	if (err != MPI_SUCCESS) {
		return(lam_errfunc(comm, BLKMPIGRAPHCREATE, err));
	}

	LAM_TRACE(lam_tr_cffend(BLKMPIGRAPHCREATE, -1, comm, 0, 0));

	lam_resetfunc(BLKMPIGRAPHCREATE);
	return(MPI_SUCCESS);
}
