/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: grank.c,v 6.1 96/11/23 22:52:08 nevin Rel $
 *
 *	Function:	- get caller's rank in group
 *	Accepts:	- group
 *			- ptr rank
 *	Returns:	- 0 or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>

int
MPI_Group_rank(group, prank)

MPI_Group		group;
int			*prank;

{
	lam_initerr();
	lam_setfunc(BLKMPIGROUPRANK);

	if ((group != MPI_GROUP_NULL) && (prank != 0)) {
		*prank = group->g_myrank;
	}
	else if (group == MPI_GROUP_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIGROUPRANK, lam_mkerr(MPI_ERR_GROUP, 0)));
	}
	else {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIGROUPRANK, lam_mkerr(MPI_ERR_ARG, 0)));
	}

	lam_resetfunc(BLKMPIGROUPRANK);
	return(MPI_SUCCESS);
}
