/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio	State University
 *	RBD/NJN
 *
 *	$Id: wait_f.c,v 6.1 96/11/22 13:44:37 nevin Rel $
 *
 *	Function:	- MPI_Wait F77 wrapper
 */

#include <lam_config.h>

#include <mpi.h>
#include <MPISYS.h>
#include <mpisys.h>

void
mpi_wait_(rq, st, ierr)

int			*rq, *st, *ierr;

{
	MPI_Request	req;
	MPI_Status	stat;

	req = GETHDL(*rq);
	*ierr =	MPI_Wait(&req, &stat);
	if (*ierr == MPI_SUCCESS) {
		lam_C2F_stat(&stat, st);
		st[6] =	-1;
		if (req	== MPI_REQUEST_NULL) {
			lam_F_typefree(*rq);
			*rq = -1;
		}
	}
}
