/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio	State University
 *	NJN
 *
 *	$Id: portclose_f.c,v 6.1 96/11/22 13:44:37 nevin Rel $
 *
 *	Function:	- MPI_Port_close F77 wrapper
 */

#include <lam_config.h>

#include <errno.h>
#include <stdlib.h>

#include <blktype.h>
#include <mpi.h>
#include <MPISYS.h>
#include <mpisys.h>

void
mpi_port_close_(p, ierr, np)

char			*p;
int			*ierr;
int			np;

{
	char		*port;

	port = lam_F2C_string(p, np);
	if (port == 0) {
		lam_setfunc(BLKMPIPORTCLOSE);
		*ierr =	lam_errfunc(MPI_COMM_WORLD, BLKMPIPORTCLOSE,
					lam_mkerr(MPI_ERR_OTHER, errno));
		return;
	}

	*ierr =	MPI_Port_close(port);
	free(port);
}
