/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio	State University
 *	NJN
 *
 *	$Id: nameget_f.c,v 6.1 96/11/22 13:44:37 nevin Rel $
 *
 *	Function:	- MPI_Name_get F77 wrapper
 */

#include <lam_config.h>

#include <errno.h>
#include <stdlib.h>

#include <blktype.h>
#include <mpi.h>
#include <MPISYS.h>
#include <mpisys.h>

void
mpi_name_get_(s, i, p, ierr, ns, np)

char			*s, *p;
int			*i, *ierr;
int			ns, np;

{
	char		*port;
	char		*service;

	port = (char *)	malloc(np + 1);
	service	= lam_F2C_string(s, ns);

	if (port == 0 || service == 0) {
		lam_setfunc(BLKMPINAMEGET);
		*ierr =	lam_errfunc(MPI_COMM_WORLD, BLKMPINAMEGET,
					lam_mkerr(MPI_ERR_OTHER, errno));
		return;
	}

	if ((*ierr = MPI_Name_get(service, GETHDL(*i), port)) != MPI_SUCCESS) {
		return;
	}

	lam_C2F_string(port, p,	np);

	free(port);
	free(service);
}
