/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: errstring.c,v 6.1 96/11/23 22:51:48 nevin Rel $
 *
 *	Function:	- return the MPI error message
 *	Accepts:	- error code
 *			- message buffer (out)
 *			- buffer length (out)
 *	Returns:	- MPI_SUCCESS
 */

#include <stdio.h>
#include <string.h>

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <terror.h>
#include <typical.h>

/*
 * error messages
 */
static char		*mpierrmsg[] = {
	"unused error code",			/* unused */
	"invalid buffer pointer",		/* MPI_ERR_BUFFER */
	"invalid count argument",		/* MPI_ERR_COUNT */
	"invalid datatype argument",		/* MPI_ERR_TYPE */
	"invalid tag argument",			/* MPI_ERR_TAG */
	"invalid communicator",			/* MPI_ERR_COMM */
	"invalid rank",				/* MPI_ERR_RANK */
	"invalid request handle",		/* MPI_ERR_REQUEST */
	"invalid root",				/* MPI_ERR_ROOT */
	"invalid group",			/* MPI_ERR_GROUP */
	"invalid operation",			/* MPI_ERR_OP */
	"invalid topology",			/* MPI_ERR_TOPOLOGY */
	"invalid dimension argument",		/* MPI_ERR_DIMS */
	"invalid argument",			/* MPI_ERR_ARG */
	"unknown error",			/* MPI_ERR_UNKNOWN */
	"message truncated",			/* MPI_ERR_TRUNCATE */
	"unclassified",				/* MPI_ERR_OTHER */
	"internal MPI error",			/* MPI_ERR_INTERN */
	"error code is in status",		/* MPI_ERR_IN_STATUS */
	"pending request",			/* MPI_ERR_PENDING */
	"out of system resources",		/* MPI_ERR_SYSRESOURCE */
	"process in local group is dead",	/* MPI_ERR_LOCALDEAD */
	"process in remote group is dead",	/* MPI_ERR_REMOTEDEAD */
	"info value truncated",			/* MPI_ERR_VALUE */
	"mismatched run-time flags",		/* MPI_ERR_FLAGS */
	"publishing service",			/* MPI_ERR_SERVICE */
	"publishing service",			/* MPI_ERR_NAME */
	"error spawning process",		/* MPI_ERR_SPAWN */
	"invalid key value",			/* MPI_ERR_KEYVAL */
	"no such key",				/* MPI_ERR_INFO_NOKEY */
	"last error code (huh?)",		/* MPI_ERR_LASTCODE */
	};

int
MPI_Error_string(errcode, msg, plen)

int			errcode;
char			*msg;
int			*plen;

{
	int		class;			/* error class */
	int		funct;			/* error function */
	int		error;			/* UNIX errno */
	int		err;			/* function error code */
	unint		len;			/* error message length */
	char		*p;			/* favourite pointer */
	char		buf[MPI_MAX_ERROR_STRING]; /* error message buffer */

	lam_initerr();
	lam_setfunc(BLKMPIERRSTRING);
/*
 * Check the arguments.
 */
	if ((msg == 0) || (plen == 0)) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIERRSTRING, lam_mkerr(MPI_ERR_ARG, 0)));
	}
/*
 * Create the error message string.
 */
	err = MPI_SUCCESS;

	if (errcode == 0) {
		sprintf(buf, "MPI: no errors");
	}

	else {
		lam_bkerr(errcode, &class, &funct, &error);
		strcpy(buf, "");
		
		if ((p = blktype(funct))) {
			strcat(buf, p);
			strcat(buf, ": ");
		}

		if ((class > 0) && (class < MPI_ERR_LASTCODE)) {
			strcat(buf, mpierrmsg[class]);
		} else {
			strcat(buf, "unknown error class");
			err = lam_mkerr(MPI_ERR_ARG, 0);
		}

		if (error > 0) {
			strcat(buf, ": ");
			LAMSetLastError(error);
			len = strlen(buf);
			lam_errorstr(buf + len, MPI_MAX_ERROR_STRING - len);
		}
	}
/*
 * Fill the user's message buffer.
 */
	strncpy(msg, buf, MPI_MAX_ERROR_STRING - 1);
	msg[MPI_MAX_ERROR_STRING - 1] = '\0';
	*plen = strlen(msg);

	if (err != MPI_SUCCESS) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPIERRSTRING, err));
	}

	lam_resetfunc(BLKMPIERRSTRING);
	return(MPI_SUCCESS);
}
