/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: errclass.c,v 6.1 96/11/23 22:51:41 nevin Rel $
 *
 *	Function:	- get error class of error code
 *	Accepts:	- error code
 *			- ptr error class (returned value)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>

int
MPI_Error_class(errcode, class)

int			errcode;
int			*class;

{
	int		func;
	int		error;

	lam_initerr();
	lam_setfunc(BLKMPIERRCLASS);
/*
 * Check the arguments.
 */
	if (class == 0) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIERRCLASS, lam_mkerr(MPI_ERR_ARG, 0)));
	}

	lam_bkerr(errcode, class, &func, &error);

	lam_resetfunc(BLKMPIERRCLASS);
	return(MPI_SUCCESS);
}
