/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: csize.c,v 6.1 96/11/23 22:51:33 nevin Rel $
 *
 *	Function:	- return the size of the communicator's group
 *	Accepts:	- communicator
 *			- ptr to size (returned value)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>

int
MPI_Comm_size(comm, psize)

MPI_Comm		comm;
int			*psize;

{
	lam_initerr();
	lam_setfunc(BLKMPICOMMSIZE);

	if (comm == MPI_COMM_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPICOMMSIZE, lam_mkerr(MPI_ERR_COMM, 0)));
	}

	if (psize == 0) {
		return(lam_errfunc(comm,
			BLKMPICOMMSIZE, lam_mkerr(MPI_ERR_ARG, 0)));
	}

	*psize = comm->c_group->g_nprocs;

	lam_resetfunc(BLKMPICOMMSIZE);
	return(MPI_SUCCESS);
}
