/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: crank.c,v 6.1 96/11/23 22:51:29 nevin Rel $
 *
 *	Function:	- get caller's rank in communicator
 *	Accepts:	- communicator
 *			- ptr rank
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>

int
MPI_Comm_rank(comm, prank)

MPI_Comm		comm;
int			*prank;

{
	lam_initerr();
	lam_setfunc(BLKMPICOMMRANK);

	if ((comm != MPI_COMM_NULL) && (prank != 0)) {
		*prank = comm->c_group->g_myrank;
	}
	else if (comm == MPI_COMM_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPICOMMRANK, lam_mkerr(MPI_ERR_COMM, 0)));
	}
	else {
		return(lam_errfunc(comm,
			BLKMPICOMMRANK, lam_mkerr(MPI_ERR_ARG, 0)));
	}

	lam_resetfunc(BLKMPICOMMRANK);
	return(MPI_SUCCESS);
}
