/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD/NJN
 *
 *	$Id: ccmp.c,v 6.1 96/11/23 22:51:19 nevin Rel $
 *
 *	Function:	- compare two communicators
 *	Accepts:	- first communicator
 *			- second communicator
 *			- comparison result (out)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <terror.h>
#include <typical.h>

int
MPI_Comm_compare(c1, c2, result)

MPI_Comm		c1;
MPI_Comm		c2;
int			*result;

{
	int		gcmp;			/* local group comparison */
	int		grcmp;			/* remote group comparison */
	int		err;

	lam_initerr();
	lam_setfunc(BLKMPICOMMCMP);
/*
 * Check the arguments.
 */
	if (result == 0) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPICOMMCMP, lam_mkerr(MPI_ERR_ARG, 0)));
	}

	if (c1 == MPI_COMM_NULL || c2 == MPI_COMM_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPICOMMCMP, lam_mkerr(MPI_ERR_COMM, 0)));
	}
/*
 * Handle the trivial cases.
 */
	if (c1 == c2) {
		*result = MPI_IDENT;
		lam_resetfunc(BLKMPICOMMCMP);
		return(MPI_SUCCESS);
	}

	if ((LAM_IS_INTER(c1) && LAM_IS_INTRA(c2))
			|| (LAM_IS_INTRA(c1) && LAM_IS_INTER(c2))) {
		*result = MPI_UNEQUAL;
		lam_resetfunc(BLKMPICOMMCMP);
		return(MPI_SUCCESS);
	}
/*
 * Compare the groups.
 */
	err = MPI_Group_compare(c1->c_group, c2->c_group, &gcmp);
	if (err) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPICOMMCMP, err));
	}

	if (LAM_IS_INTER(c1) && (gcmp != MPI_UNEQUAL)) {
		err = MPI_Group_compare(c1->c_rgroup, c2->c_rgroup, &grcmp);
		if (err) {
			return(lam_errfunc(MPI_COMM_WORLD, BLKMPICOMMCMP, err));
		}

		gcmp = max(gcmp, grcmp);
	}

	*result = (gcmp == MPI_IDENT) ? MPI_CONGRUENT: gcmp;

	lam_resetfunc(BLKMPICOMMCMP);
	return(MPI_SUCCESS);
}
