/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: cartshift.c,v 6.1 96/11/23 22:51:17 nevin Rel $
 *
 *	Function:	- get src and dest ranks in cartesian shift
 *	Accepts:	- communicator
 *			- dimension of shift
 *			- displacement
 *			- ptr source rank
 *			- ptr destination rank
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>

int
MPI_Cart_shift(comm, dim, disp, psrc, pdest)

MPI_Comm		comm;
int			dim;
int			disp;
int			*psrc;
int			*pdest;

{
	int		factor;
	int		thisdim;
	int		thisperiod;
	int		ord;
	int		srcord;
	int		destord;
	int		i;
	int		*p;

	lam_initerr();
	lam_setfunc(BLKMPICARTSHIFT);
/*
 * Check the arguments.
 */
	if (comm == MPI_COMM_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPICARTSHIFT, lam_mkerr(MPI_ERR_COMM, 0)));
	}

	if (LAM_IS_INTER(comm)) {
		return(lam_errfunc(comm,
			BLKMPICARTSHIFT, lam_mkerr(MPI_ERR_COMM, 0)));
	}

	if (!LAM_IS_CART(comm)) {
		return(lam_errfunc(comm, BLKMPICARTSHIFT,
				lam_mkerr(MPI_ERR_TOPOLOGY, 0)));
	}

	if ((dim < 0) || (dim >= comm->c_topo_ndims)) {
		return(lam_errfunc(comm,
			BLKMPICARTSHIFT, lam_mkerr(MPI_ERR_DIMS, 0)));
	}

	if ((psrc == 0) || (pdest == 0)) {
		return(lam_errfunc(comm,
			BLKMPICARTSHIFT, lam_mkerr(MPI_ERR_ARG, 0)));
	}
/*
 * Handle the trivial case.
 */
	ord = comm->c_group->g_myrank;
	if (disp == 0) {
		*pdest = *psrc = ord;
		lam_resetfunc(BLKMPICARTSHIFT);
		return(MPI_SUCCESS);
	}
/*
 * Compute the rank factor and ordinate.
 */
	factor = comm->c_topo_nprocs;
	p = comm->c_topo_dims;
	for (i = 0; (i < comm->c_topo_ndims) && (i <= dim); ++i, ++p) {
		if ((thisdim = *p) > 0) {
			thisperiod = 0;
		} else {
			thisperiod = 1;
			thisdim = -thisdim;
		}

		ord %= factor;
		factor /= thisdim;
	}

	ord /= factor;
/*
 * Check the displacement value and compute the new ranks.
 */
	*psrc = *pdest = MPI_UNDEFINED;

	srcord = ord - disp;
	destord = ord + disp;

	if ( ((destord < 0) || (destord >= thisdim)) && (!thisperiod) ) {
		*pdest = MPI_PROC_NULL;
	} else {
		destord %= thisdim;
		if (destord < 0) destord += thisdim;

		*pdest = comm->c_group->g_myrank + ((destord - ord) * factor);
	}

	if ( ((srcord < 0) || (srcord >= thisdim)) && (!thisperiod) ) {
		*psrc = MPI_PROC_NULL;
	} else {
		srcord %= thisdim;
		if (srcord < 0) srcord += thisdim;

		*psrc = comm->c_group->g_myrank + ((srcord - ord) * factor);
	}

	lam_resetfunc(BLKMPICARTSHIFT);
	return(MPI_SUCCESS);
}
