/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: cartcoords.c,v 6.1 96/11/23 22:51:07 nevin Rel $
 *
 *	Function:	- translate rank to coordinates
 *	Accepts:	- communicator
 *			- rank
 *			- max # dimensions to fill
 *			- coordinates array (returned value)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>

int
MPI_Cart_coords(comm, rank, maxdims, coords)

MPI_Comm		comm;
int			rank;
int			maxdims;
int			*coords;

{
	int		dim;
	int		remprocs;
	int		i;
	int		*d;

	lam_initerr();
	lam_setfunc(BLKMPICARTCOORDS);
/*
 * Check the arguments.
 */
	if (comm == MPI_COMM_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPICARTCOORDS, lam_mkerr(MPI_ERR_COMM, 0)));
	}

	if (LAM_IS_INTER(comm)) {
		return(lam_errfunc(comm,
			BLKMPICARTCOORDS, lam_mkerr(MPI_ERR_COMM, 0)));
	}

	if (!LAM_IS_CART(comm)) {
		(lam_errfunc(comm, BLKMPICARTCOORDS,
				lam_mkerr(MPI_ERR_TOPOLOGY, 0)));
	}

	if ((rank < 0) || (rank >= comm->c_group->g_nprocs)) {
		return(lam_errfunc(comm,
			BLKMPICARTCOORDS, lam_mkerr(MPI_ERR_RANK, 0)));
	}

	if ((maxdims < 0) || ((maxdims > 0) && (coords == 0))) {
		return(lam_errfunc(comm,
			BLKMPICARTCOORDS, lam_mkerr(MPI_ERR_ARG, 0)));
	}
/*
 * Loop computing the coordinates.
 */
	d = comm->c_topo_dims;
	remprocs = comm->c_topo_nprocs;
	for (i = 0; (i < comm->c_topo_ndims) && (i < maxdims); ++i, ++d) {
		dim = (*d > 0) ? *d : -(*d);
		remprocs /= dim;
		*coords++ = rank / remprocs;
		rank %= remprocs;
	}

	lam_resetfunc(BLKMPICARTCOORDS);
	return(MPI_SUCCESS);
}
