/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	JRV/RBD
 *
 *	$Id: allgatherv.c,v 6.1 96/11/23 22:50:43 nevin Rel $
 *
 *	Function:	- gather varying length buffers at all process ranks
 *	Accepts:	- send buffer
 *			- send count
 *			- send datatype
 *			- recv buffer
 *			- recv counts
 *			- displacements
 *			- recv datatype
 *			- communicator
 *	Returns:	- MPI_SUCCESS or an MPI error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>

int
MPI_Allgatherv(sbuf, scount, sdtype,
			rbuf, rcounts, disps, rdtype, comm)

void			*sbuf;
int			scount;
MPI_Datatype		sdtype;
void			*rbuf;
int			*rcounts;
int			*disps;
MPI_Datatype		rdtype;
MPI_Comm		comm;

{
	int		i;			/* favourite index */
	int		size;			/* group size */
	int		err;			/* error code */

	lam_initerr();
	lam_setfunc(BLKMPIALLGATHERV);
/*
 * Check for invalid arguments.
 */
	if ((comm == MPI_COMM_NULL) || LAM_IS_INTER(comm)) {
		return(lam_errfunc(comm, BLKMPIALLGATHERV,
				lam_mkerr(MPI_ERR_COMM, 0)));
	}

	if ((sdtype == MPI_DATATYPE_NULL) || (rdtype == MPI_DATATYPE_NULL)) {
		return(lam_errfunc(comm, BLKMPIALLGATHERV,
				lam_mkerr(MPI_ERR_TYPE, 0)));
	}

	if (disps == 0) {
		return(lam_errfunc(comm, BLKMPIALLGATHERV,
				lam_mkerr(MPI_ERR_ARG, 0)));
	}

	if ((scount < 0) || (rcounts == 0)) {
		return(lam_errfunc(comm, BLKMPIALLGATHERV,
				lam_mkerr(MPI_ERR_COUNT, 0)));
	}

	LAM_TRACE(lam_tr_cffstart(BLKMPIALLGATHERV));
/*
 * Collect all values at each process, one at a time.
 */
	MPI_Comm_size(comm, &size);

	for (i = 0; i < size; ++i) {

		err = MPI_Gatherv(sbuf, scount, sdtype, rbuf,
					rcounts, disps, rdtype, i, comm);
		if (err != MPI_SUCCESS) {
			return(lam_errfunc(comm, BLKMPIALLGATHERV, err));
		}
	}

	LAM_TRACE(lam_tr_cffend(BLKMPIALLGATHERV, -1, comm, sdtype, scount));

	lam_resetfunc(BLKMPIALLGATHERV);
	return(MPI_SUCCESS);
}
