/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	JRV/RBD
 *
 *	$Id: allgather.c,v 6.1 96/11/23 22:50:42 nevin Rel $
 *
 *	Function:	- gather buffers at all process ranks
 *	Accepts:	- send buffer
 *			- send count
 *			- send datatype
 *			- recv buffer
 *			- recv count
 *			- recv datatype
 *			- communicator
 *	Returns:	- MPI_SUCCESS or an MPI error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>

int
MPI_Allgather(sbuf, scount, sdtype, rbuf, rcount, rdtype, comm)

void			*sbuf;
int			scount;
MPI_Datatype		sdtype;
void			*rbuf;
int			rcount;
MPI_Datatype		rdtype;
MPI_Comm		comm;

{
	int		err;			/* error code */
	int		size;			/* group size */

	lam_initerr();
	lam_setfunc(BLKMPIALLGATHER);
/*
 * Check for invalid arguments.
 */
	if ((comm == MPI_COMM_NULL) || LAM_IS_INTER(comm)) {
		return(lam_errfunc(comm, BLKMPIALLGATHER,
				lam_mkerr(MPI_ERR_COMM, 0)));
	}

	if ((sdtype == MPI_DATATYPE_NULL) || (rdtype == MPI_DATATYPE_NULL)) {
		return(lam_errfunc(comm, BLKMPIALLGATHER,
				lam_mkerr(MPI_ERR_TYPE, 0)));
	}

	if ((scount < 0) || (rcount < 0)) {
		return(lam_errfunc(comm, BLKMPIALLGATHER,
				lam_mkerr(MPI_ERR_COUNT, 0)));
	}

	LAM_TRACE(lam_tr_cffstart(BLKMPIALLGATHER));
/*
 * Gather and broadcast.
 */
	MPI_Comm_size(comm, &size);

	err = MPI_Gather(sbuf, scount, sdtype, rbuf, rcount, rdtype, 0, comm);
	if (err != MPI_SUCCESS) {
		return(lam_errfunc(comm, BLKMPIALLGATHER, err));
	}

	err = MPI_Bcast(rbuf, rcount * size, rdtype, 0, comm);
	if (err != MPI_SUCCESS) {
		return(lam_errfunc(comm, BLKMPIALLGATHER, err));
	}

	LAM_TRACE(lam_tr_cffend(BLKMPIALLGATHER, -1, comm, sdtype, scount));

	lam_resetfunc(BLKMPIALLGATHER);
	return(MPI_SUCCESS);
}
