/*
 *	Ohio Trollius
 *	Copyright 1995 The Ohio State University
 *	GDB
 *
 *	$Log:	kstate.c,v $
 * Revision 6.1  96/11/23  22:49:23  nevin
 * Ohio Release
 * 
 * Revision 6.0  96/08/30  18:44:06  nevin
 * Ohio Release
 * 
 * Revision 5.2.1.1  96/01/13  11:16:37  gdburns
 * Obtain process fyi structure from the kernel.
 * 
 * Revision 5.2  94/08/22  14:01:43  gdburns
 * Ohio Release
 * 
 * Revision 5.1.1.1  94/08/18  11:37:41  gdburns
 * upgrade for new kernel
 * 
 * Revision 5.1  94/05/18  12:45:30  gdburns
 * Ohio Release
 * 
 * Revision 2.3  94/04/22  12:39:32  gdburns
 * Ohio Release
 * 
 *	Function:	- obtains process status from kernel
 *	Accepts:	- process ID
 *			- kernel status structure ptr
 *	Returns:	- 0 or ERROR
 */

#include <string.h>

#include <kio.h>
#include <kreq.h>
#include <typical.h>

/*
 * external variables
 */
extern struct kio_t	_kio;		/* kernel I/O block */
extern int		errno;

/*
 * external functions
 */
extern int		_cipc_kreq();	/* make kernel request */

int
kstate(pid, pstate)

int			pid;
struct kstatus		*pstate;

{
	struct kreq	req;		/* kernel request */
	struct kreply	reply;		/* kernel reply */
/*
 * Formulate the KQSTATE kernel request.
 */
	req.kq_req = KQSTATE;
	req.kq_index = _kio.ki_index;
	req.kq_pid = pid;

	if (_cipc_kreq(&req, &reply)) {
		return(LAMERROR);
	}

	if (reply.kr_reply) {
		errno = reply.kr_reply;
		return(LAMERROR);
	}

	pstate->ks_state = reply.kr_state;
	pstate->ks_priority = reply.kr_priority; 
	pstate->ks_event = reply.kr_event;
	pstate->ks_type = reply.kr_type;
	pstate->ks_length = reply.kr_length;
	pstate->ks_signal = reply.kr_sigs;
	memcpy((char *) pstate->ks_fyi, (char *) reply.kr_fyi,
			sizeof(reply.kr_fyi));

	return(0);
}
