/*
 *	Ohio Trollius
 *	Copyright 1995 The Ohio State University
 *	GDB
 *
 *	$Log:	ksend.c,v $
 * Revision 6.1  96/11/23  22:49:19  nevin
 * Ohio Release
 * 
 * Revision 6.0  96/08/30  18:44:06  nevin
 * Ohio Release
 * 
 * Revision 5.2.1.1  96/01/13  11:08:45  gdburns
 * Add block time tracing.
 * 
 * Revision 5.2  94/08/22  14:01:41  gdburns
 * Ohio Release
 * 
 * Revision 5.1.1.1  94/08/18  11:37:39  gdburns
 * upgrade for new kernel
 * 
 * Revision 5.1  94/05/18  12:45:28  gdburns
 * Ohio Release
 * 
 * Revision 2.3  94/04/22  12:39:31  gdburns
 * Ohio Release
 * 
 *	Function:	- sends a message to another process
 *	Accepts:	- kernel message descriptor ptr
 *	Returns:	- 0 or ERROR
 */

#include <kio.h>
#include <kreq.h>
#include <terror.h>
#include <typical.h>

/*
 * external variables
 */
extern struct kio_t	_kio;		/* kernel I/O block */

/*
 * external functions
 */
extern int		_cipc_ksend();	/* ITB/OTB msg send */
extern void		_ksig_follow();	/* check signals */

int
ksend(pkmsg)

struct kmsg		*pkmsg;		/* message desc. ptr */

{
	struct kreq	req;		/* kernel request */
	struct kreply	reply;		/* kernel reply */
/*
 * Formulate the KQSEND request.
 */
	req.kq_req = KQSEND;
	req.kq_index = _kio.ki_index;
	req.kq_msg.k_event = pkmsg->k_event;
	req.kq_msg.k_type = pkmsg->k_type;
	req.kq_msg.k_flags = pkmsg->k_flags;
	req.kq_msg.k_length = pkmsg->k_length;
	req.kq_msg.k_msg = pkmsg->k_msg;
/*
 * Loop through possible signal interruptions.
 */
	do {
		if (_cipc_ksend(&req, &reply)) return(LAMERROR);

		if (pkmsg->k_flags & KTRACE) {
			_kio.ki_blktime += reply.kr_blktime;
		}
/*
 * Do we need to follow a signal?
 */
		if (reply.kr_signal) {
			_kio.ki_signal |= reply.kr_signal;
			_ksig_follow();
		}

	} while ((reply.kr_reply == EINTR) &&
			((reply.kr_signal & _kio.ki_sigretry) ==
			reply.kr_signal));

	if (reply.kr_reply) {
		errno = reply.kr_reply;
		return(LAMERROR);
	}

	pkmsg->k_length = reply.kr_length;
	return(0);
}
