/*
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	GDB
 *
 *	$Id: kexit.c,v 6.1.1.1 97/01/27 17:52:53 nevin Exp $
 *
 *	Function:	- exit package
 *			- performs all tasks required when a process exits
 */

#include <stdio.h>

#include <kio.h>
#include <terror.h>
#include <typical.h>

/*
 * global functions
 */
void			_kexit();
void			kexit();
void			lam_kexit();
int			atkexit();

/*
 * external variables
 */
extern struct kio_t	_kio;			/* Kernel Input/Output block */

/*
 * external functions
 */
extern int		rpdetach();
extern void		_cio_cleanup();	 	/* destroy mesasge queues */
extern void		_cio_bail();		/* terminate self */

/*
 *	atkexit
 *
 *	Function:	- add function to cleanup table
 *	Accepts:	- pointer to exit function
 *			- argument to exit function
 *			- does not store a combination of exit function
 *			  and argument more than once
 *	Returns:	- 0 or ERROR
 */
int
atkexit(exitfunc, arg)

void			(*exitfunc)();
char			*arg;

{
	int		i;		/* favourite index variable */

	for (i = 0; (i < TNEXIT) && (_kio.ki_exit[i]) &&
			!((_kio.ki_exit[i] == exitfunc) &&
			(_kio.ki_arg[i] == arg)); ++i);

	if (i < TNEXIT) {

		if (!_kio.ki_exit[i]) {
			_kio.ki_exit[i] = exitfunc;
			_kio.ki_arg[i] = arg;
		}

		return(0);
	}

	else {
		errno = ENOEXDESCRIPTORS;
		return(LAMERROR);
	}
}

/*
 *	lam_kexit
 *
 *	Function:	- terminates Trollius runtime system
 *			- calls cleanup routines
 *			- detaches from kenyad and the kernel
 *	Accepts:	- exit status
 */
void
lam_kexit(status)

int			status;

{
	int		i;

	if (_kio.ki_pid == getpid()) {

		for (i = TNEXIT - 1; i >= 0; --i) {

			if (_kio.ki_exit[i]) {
				(*(_kio.ki_exit[i]))(_kio.ki_arg[i], status);
			}
		}

		if (_kio.ki_rtf & RTF_IO) {
			fflush(stdout);
			fflush(stderr);
		}
		
		if (_kio.ki_rtf & RTF_KENYA) {
			lpdetach(0, status);
		}

		kdetach(0);
	}
/*
 * Destroy underlying communication structures and free related resources.
 */
	_cio_cleanup();
}

/*
 *	kexit
 *
 *	Function:	- exits from Trollius
 *			- calls cleanup routines
 *			- does not return
 *	Accepts:	- exit status
 */
void
kexit(status)

int			status;

{
	lam_kexit(status);
/*
 * _cio_bail does not return.
 */
	_cio_bail(status);
}

/*
 *	_kexit
 *
 *	Function:	- exits from Trollius
 *			- does not call cleanup routines
 *			- does not return
 *	Accepts:	- exit status
 */
void
_kexit(status)

int			status;

{
	if (_kio.ki_pid == getpid()) {

		if (_kio.ki_rtf & RTF_KENYA) {
			lpdetach(0, status);
		}

		kdetach(0);
	}
/*
 * Destroy underlying communication structures and free related resources.
 */
	_cio_cleanup();
/*
 * _cio_bail does not return.
 */
	_cio_bail(status);
}
