/*
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	NJN
 *
 *	$Id: shm.sysv.h,v 6.1.1.2 97/03/24 12:04:39 nevin Exp $
 *
 *	Function:	- shared memory / TCP client-to-client interface header
 *			- System V semaphores
 */

#ifndef _SHM_SYSV_H
#define _SHM_SYSV_H

#include <errno.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/sem.h>

#include <all_hash.h>
#include <all_list.h>
#include <mpisys.h>
#include <portable.h>
#include <t_types.h>

/*
 * constants
 */
#define C2CINITSIZE	0			/* initialization data size */
#define INITHASH	((int4) 32)		/* initial hash table size */
#define LAMSHMDELAY	10			/* poll loop delay (usecs) */
#define TCPSHORTMSGLEN 	16384			/* max. length tcp short msg */
#define SHMBLKSIZE 	16384			/* size of shm block */
#define SHMBUFSIZE 	(SHMBLKSIZE / 2)	/* size of shm buffer */
#define SHMSHORTMSGLEN	(SHMBUFSIZE - sizeof(struct c2c_envl))
						/* max. length shm short msg */
/*
 * data structures
 *
 *
 * client-to-client specific process data
 */
struct c2c_proc {
	struct c2c_envl	cp_env;			/* incoming envelope */
	int		cp_write;		/* ok to try to write flag */
	int		cp_read;		/* ok to try to read flag */
	int		cp_sock;		/* socket descriptor */
	char		*cp_envbuf;		/* envelope buffer pointer */
	int		cp_nenvin;		/* # env. bytes left to read */
	char		*cp_msgbuf;		/* message buffer pointer */
	int		cp_nmsgin;		/* # msg. bytes left to read */
	int		cp_extra;		/* # bytes to go into sink */
	int		cp_shm;			/* id of shm block */
	int		cp_sem;			/* id of semaphore set */
	int		cp_locked;		/* reader has a lock? */
	char		*cp_shmbuf;		/* shared memory buffer */
	char		*cp_shmout;		/* outgoing shm buffer */
	char		*cp_shmin;		/* incoming shm buffer */
	struct sembuf	*cp_lop;		/* lock operations */
	struct sembuf	*cp_top;		/* try lock operations */
	struct sembuf	*cp_uop;		/* unlock operations */
	MPI_Request	cp_wreq;		/* req. writing to process */
	MPI_Request	cp_rreq;		/* reading req. */
	MPI_Request	cp_mreq;		/* req. to test matching from */
	int		(*cp_readfn)();		/* read function */
	struct cbuf_msg *cp_bmsg;		/* buffering? */
	int		cp_nbfde;		/* # buffered envelopes */
};

/*
 * locking macros
 */
#define _shm_readtrylock(p)  \
	((semop((p)->cp_sem, (p)->cp_top, 1)) ? \
		((errno == EAGAIN) ? 1 : -1) : 0)

#define _shm_writetrylock(p) \
	((semop((p)->cp_sem, (p)->cp_top + 1, 1)) ? \
		((errno == EAGAIN) ? 1 : -1) : 0)

#define _shm_readunlock(p)	semop((p)->cp_sem, (p)->cp_uop, 1)
#define _shm_writeunlock(p)	semop((p)->cp_sem, (p)->cp_uop + 1, 1)

/*
 * prototypes of LAM MPI library client-to-client internal functions
 */
#ifndef __ARGS
#if __STDC__ || defined(c_plusplus) || defined(__cplusplus)
#define __ARGS(a)	a
#else
#define __ARGS(a)	()
#endif
#endif

#ifdef __cplusplus
extern "C" {
#endif

extern int	_shm_readlock __ARGS((struct c2c_proc *));
extern int	_shm_writelock __ARGS((struct c2c_proc *));

#ifdef __cplusplus
}
#endif

#endif	/* _SHM_SYSV_H */
