/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD/NJN
 *
 *	$Id: mpi.h,v 6.1 96/11/23 21:55:11 nevin Rel $
 *
 *	Function:	- MPI header file
 */

#ifndef _MPI_H
#define _MPI_H

/*
 * MPI version
 */
#define MPI_VERSION		1
#define MPI_SUBVERSION		1

/*
 * typedefs
 */
typedef struct _group		*MPI_Group;
typedef struct _comm		*MPI_Comm;
typedef struct _dtype		*MPI_Datatype;
typedef struct _req		*MPI_Request;
typedef struct _op		*MPI_Op;
typedef struct _status		MPI_Status;
typedef struct _errhdl		*MPI_Errhandler;
typedef void			*MPI_Buffer;
typedef void			*MPI_Info;
typedef long			MPI_Aint;

/*
 * user typedefs
 */
#if __STDC__ || defined(c_plusplus) || defined(__cplusplus)
typedef int	(MPI_Copy_function)(MPI_Comm, int, void *,
					void *, void *, int *);
typedef int	(MPI_Delete_function)(MPI_Comm, int, void *, void *);
typedef void	(MPI_Handler_function)(MPI_Comm *, int *, ...);
typedef void	(MPI_User_function)(void *, void *, int *, MPI_Datatype *);
#else
typedef int	(MPI_Copy_function)();
typedef int	(MPI_Delete_function)();
typedef void	(MPI_Handler_function)();
typedef void	(MPI_User_function)();
#endif

/*
 * misc. constants
 */
#define MPI_SUCCESS		0		/* no errors */
#define MPI_ANY_SOURCE		-1		/* match any source rank */
#define MPI_PROC_NULL		-2		/* rank of null process */
#define MPI_CANCEL_SOURCE	-3		/* successful cancel */
#define MPI_ANY_TAG		-1		/* match any message tag */
#define MPI_GER_TAG		-2		/* used for GER protocol */
#define MPI_MERGE_TAG		-3		/* used to merge inter-comm */
#define MPI_MAX_CID		0xFFE		/* max pt2pt context ID */
#define MPI_GER_CID		0xFFF		/* used for GER protocol */
#define MPI_MAX_PROCESSOR_NAME	256		/* max proc. name length */
#define MPI_MAX_ERROR_STRING	256		/* max error message length */
#define MPI_UNDEFINED		-32766		/* undefined stuff */
#define MPI_CART		1		/* cartesian topology */
#define MPI_GRAPH		2		/* graph topology */
#define MPI_KEYVAL_INVALID	-1		/* invalid key value */
#define MPI_TAG_UB		0		/* predefined attribute key */
#define MPI_HOST		1		/* predefined attribute key */
#define MPI_IO			2		/* predefined attribute key */
#define MPI_WTIME_IS_GLOBAL	3		/* predefined attribute key */
#define MPI_UNIVERSE_SIZE	4		/* predefined attribute key */
#define MPI_BOTTOM		((void *) 0)
#define MPI_BSEND_OVERHEAD	(sizeof(struct _bsndhdr) + sizeof(void *))
#define MPI_INFO_MAX_KEYLEN	32		/* max info key length */
#define MPI_INFO_MAX_VALUELEN	256		/* max info value length */
#define MPI_ARGV_NULL		((char **) 0)	/* NULL argument vector */
#define MPI_ARGVS_NULL		((char ***) 0)	/* NULL argument vectors */
#define MPI_ERRCODES_DONTCARE	((void *) 0)	/* don't return error codes */
#define MPI_MAX_NAME_LEN	32		/* max port name length */

/*
 * error classes
 */
#define MPI_ERR_BUFFER		1	/* invalid buffer pointer */
#define MPI_ERR_COUNT		2	/* invalid count argument */
#define MPI_ERR_TYPE		3	/* invalid datatype argument */
#define MPI_ERR_TAG		4	/* invalid tag argument */
#define MPI_ERR_COMM		5	/* invalid communicator */
#define MPI_ERR_RANK		6	/* invalid rank */
#define MPI_ERR_REQUEST		7	/* invalid request handle */
#define MPI_ERR_ROOT		8	/* invalid root */
#define MPI_ERR_GROUP		9	/* invalid group */
#define MPI_ERR_OP		10	/* invalid operation */
#define MPI_ERR_TOPOLOGY	11	/* invalid topology */
#define MPI_ERR_DIMS		12	/* invalid dimension argument */
#define MPI_ERR_ARG		13	/* invalid argument */
#define MPI_ERR_UNKNOWN		14	/* unknown error */
#define MPI_ERR_TRUNCATE	15	/* message truncated on receive */
#define MPI_ERR_OTHER		16	/* LAM error */
#define MPI_ERR_INTERN		17	/* internal MPI error */
#define MPI_ERR_IN_STATUS	18	/* error code is in status */
#define MPI_ERR_PENDING		19	/* pending request */
#define MPI_ERR_SYSRESOURCE	20	/* out of system resources */
#define MPI_ERR_LOCALDEAD	21	/* process in local group is dead */
#define MPI_ERR_REMOTEDEAD	22	/* process in remote group is dead */
#define MPI_ERR_VALUE		23	/* truncated info value */
#define MPI_ERR_FLAGS		24	/* mismatched run-time flags */
#define MPI_ERR_SERVICE		25	/* name publishing service error */
#define MPI_ERR_NAME		26	/* name not published */
#define MPI_ERR_SPAWN		27	/* error while spawning processes */
#define MPI_ERR_KEYVAL		28	/* invalid key value */
#define MPI_ERR_INFO_NOKEY	29	/* no such info key */
#define MPI_ERR_LASTCODE	30	/* last error code */

/*
 * comparison results
 */
#define MPI_IDENT		1
#define MPI_CONGRUENT		2
#define MPI_SIMILAR		3
#define MPI_UNEQUAL		4

/*
 * NULL handles
 */
#define MPI_GROUP_NULL		((MPI_Group) 0)
#define MPI_COMM_NULL		((MPI_Comm) 0)
#define MPI_DATATYPE_NULL	((MPI_Datatype) 0)
#define MPI_REQUEST_NULL	((MPI_Request) 0)
#define MPI_OP_NULL		((MPI_Op) 0)
#define MPI_ERRHANDLER_NULL	((MPI_Errhandler) 0)
#define MPI_NULL_COPY_FN	((MPI_Copy_function *) 0)
#define MPI_NULL_DELETE_FN	((MPI_Delete_function *) 0)
#define MPI_INFO_NULL		((void *) 0)

/*
 * Transparent MPI data type.
 */
struct _status { 
	int		MPI_SOURCE;
	int		MPI_TAG;
	int		MPI_ERROR;
	int		st_count;		/* top element count */
	int		st_nelem;		/* low element count */
	int		st_length;		/* message length */
	MPI_Datatype	st_dtype;		/* datatype */
};

/*
 * Needed for determining MPI_BSEND_OVERHEAD.
 */
struct _bsndhdr {
	MPI_Request	bsh_req;
	int		bsh_size;
	struct _bsndhdr	*bsh_prev;
	struct _bsndhdr	*bsh_next;
};

/*
 * external variables
 */
extern struct _comm		lam_mpi_comm_world;
extern struct _comm		lam_mpi_comm_self;
extern struct _comm		lam_mpi_comm_parent;

extern struct _group		lam_mpi_group_empty;

extern struct _op		lam_mpi_max, lam_mpi_min;
extern struct _op		lam_mpi_sum, lam_mpi_prod;
extern struct _op		lam_mpi_land, lam_mpi_band;
extern struct _op		lam_mpi_lor, lam_mpi_bor;
extern struct _op		lam_mpi_lxor, lam_mpi_bxor;
extern struct _op		lam_mpi_maxloc, lam_mpi_minloc;

extern struct _dtype		lam_mpi_char, lam_mpi_byte;
extern struct _dtype		lam_mpi_int, lam_mpi_logic;
extern struct _dtype		lam_mpi_short, lam_mpi_long;
extern struct _dtype		lam_mpi_float, lam_mpi_double;
extern struct _dtype		lam_mpi_long_double;
extern struct _dtype		lam_mpi_cplex, lam_mpi_packed;
extern struct _dtype		lam_mpi_unsigned_char;
extern struct _dtype		lam_mpi_unsigned_short;
extern struct _dtype		lam_mpi_unsigned;
extern struct _dtype		lam_mpi_unsigned_long;
extern struct _dtype		lam_mpi_ub, lam_mpi_lb;
extern struct _dtype		lam_mpi_float_int, lam_mpi_double_int;
extern struct _dtype		lam_mpi_long_int, lam_mpi_2int;
extern struct _dtype		lam_mpi_2float, lam_mpi_2double;
extern struct _dtype		lam_mpi_short_int, lam_mpi_dblcplex;
extern struct _dtype		lam_mpi_integer, lam_mpi_real;
extern struct _dtype		lam_mpi_dblprec, lam_mpi_character;
extern struct _dtype		lam_mpi_2real, lam_mpi_2dblprec;
extern struct _dtype		lam_mpi_2integer, lam_mpi_longdbl_int;

extern struct _errhdl		lam_mpi_errors_are_fatal;
extern struct _errhdl		lam_mpi_errors_return;

/*
 * MPI predefined handles
 */
#define MPI_COMM_WORLD		((MPI_Comm) &lam_mpi_comm_world)
#define MPI_COMM_SELF		((MPI_Comm) &lam_mpi_comm_self)
#define MPI_COMM_PARENT		((MPI_Comm) &lam_mpi_comm_parent)

#define MPI_GROUP_EMPTY		((MPI_Group) &lam_mpi_group_empty)

#define MPI_MAX			((MPI_Op) &lam_mpi_max)
#define MPI_MIN			((MPI_Op) &lam_mpi_min)
#define MPI_SUM			((MPI_Op) &lam_mpi_sum)
#define MPI_PROD		((MPI_Op) &lam_mpi_prod)
#define MPI_LAND		((MPI_Op) &lam_mpi_land)
#define MPI_BAND		((MPI_Op) &lam_mpi_band)
#define MPI_LOR			((MPI_Op) &lam_mpi_lor)
#define MPI_BOR			((MPI_Op) &lam_mpi_bor)
#define MPI_LXOR		((MPI_Op) &lam_mpi_lxor)
#define MPI_BXOR		((MPI_Op) &lam_mpi_bxor)
#define MPI_MAXLOC		((MPI_Op) &lam_mpi_maxloc)
#define MPI_MINLOC		((MPI_Op) &lam_mpi_minloc)

#define MPI_BYTE		((MPI_Datatype) &lam_mpi_byte)
#define MPI_PACKED		((MPI_Datatype) &lam_mpi_packed)
#define MPI_CHAR		((MPI_Datatype) &lam_mpi_char)
#define MPI_SHORT		((MPI_Datatype) &lam_mpi_short)
#define MPI_INT			((MPI_Datatype) &lam_mpi_int)
#define MPI_LONG		((MPI_Datatype) &lam_mpi_long)
#define MPI_FLOAT		((MPI_Datatype) &lam_mpi_float)
#define MPI_DOUBLE		((MPI_Datatype) &lam_mpi_double)
#define MPI_LONG_DOUBLE		((MPI_Datatype) &lam_mpi_long_double)
#define MPI_UNSIGNED_CHAR	((MPI_Datatype) &lam_mpi_unsigned_char)
#define MPI_UNSIGNED_SHORT	((MPI_Datatype) &lam_mpi_unsigned_short)
#define MPI_UNSIGNED_LONG	((MPI_Datatype) &lam_mpi_unsigned_long)
#define MPI_UNSIGNED		((MPI_Datatype) &lam_mpi_unsigned)
#define MPI_FLOAT_INT		((MPI_Datatype) &lam_mpi_float_int)
#define MPI_DOUBLE_INT		((MPI_Datatype) &lam_mpi_double_int)
#define MPI_LONG_DOUBLE_INT	((MPI_Datatype) &lam_mpi_longdbl_int)
#define MPI_LONG_INT		((MPI_Datatype) &lam_mpi_long_int)
#define MPI_SHORT_INT		((MPI_Datatype) &lam_mpi_short_int)
#define MPI_2INT		((MPI_Datatype) &lam_mpi_2int)
#define MPI_2FLOAT		((MPI_Datatype) &lam_mpi_2float)
#define MPI_2DOUBLE		((MPI_Datatype) &lam_mpi_2double)
#define MPI_UB			((MPI_Datatype) &lam_mpi_ub)
#define MPI_LB			((MPI_Datatype) &lam_mpi_lb)

#define MPI_ERRORS_ARE_FATAL	((MPI_Errhandler) &lam_mpi_errors_are_fatal)
#define MPI_ERRORS_RETURN	((MPI_Errhandler) &lam_mpi_errors_return)

/*
 * prototypes
 */
#ifndef __ARGS
#if __STDC__ || defined(c_plusplus) || defined(__cplusplus)
#define __ARGS(a)	a
#else
#define __ARGS(a)	()
#endif
#endif

#ifdef __cplusplus
extern "C" {
#endif

extern int MPI_Abort __ARGS((MPI_Comm, int));
extern int MPI_Accept __ARGS((char *, MPI_Info, int, MPI_Comm, MPI_Comm *));
extern int MPI_Address __ARGS((void *, MPI_Aint *));
extern int MPI_Allgather __ARGS((void *, int, MPI_Datatype, void *,
				int, MPI_Datatype, MPI_Comm));
extern int MPI_Allgatherv __ARGS((void *, int, MPI_Datatype, void *,
				int *, int *, MPI_Datatype, MPI_Comm));
extern int MPI_Allreduce __ARGS((void *, void *, int, MPI_Datatype,
				MPI_Op, MPI_Comm));
extern int MPI_Alltoall __ARGS((void *, int, MPI_Datatype, void *,
				int, MPI_Datatype, MPI_Comm));
extern int MPI_Alltoallv __ARGS((void *, int *, int *, MPI_Datatype, void *,
				int *, int *, MPI_Datatype, MPI_Comm));
extern int MPI_Attr_delete __ARGS((MPI_Comm, int));
extern int MPI_Attr_get __ARGS((MPI_Comm, int, void *, int *));
extern int MPI_Attr_put __ARGS((MPI_Comm, int, void *));
extern int MPI_Barrier __ARGS((MPI_Comm));
extern int MPI_Bcast __ARGS((void *, int, MPI_Datatype, int, MPI_Comm));
extern int MPI_Bsend __ARGS((void *, int, MPI_Datatype, int, int, MPI_Comm));
extern int MPI_Bsend_init __ARGS((void *, int, MPI_Datatype, int,
				int, MPI_Comm, MPI_Request *));
extern int MPI_Buffer_attach __ARGS((void *, int));
extern int MPI_Buffer_detach __ARGS((void *, int *));
extern int MPI_Cancel __ARGS((MPI_Request *));
extern int MPI_Cart_coords __ARGS((MPI_Comm, int, int, int *));
extern int MPI_Cart_create __ARGS((MPI_Comm, int, int *, int *,
				int, MPI_Comm *));
extern int MPI_Cart_get __ARGS((MPI_Comm, int, int *, int *, int *));
extern int MPI_Cart_map __ARGS((MPI_Comm, int, int *, int *, int *));
extern int MPI_Cart_rank __ARGS((MPI_Comm, int *, int *));
extern int MPI_Cart_shift __ARGS((MPI_Comm, int, int, int *, int *));
extern int MPI_Cart_sub __ARGS((MPI_Comm, int *, MPI_Comm *));
extern int MPI_Cartdim_get __ARGS((MPI_Comm, int *));
extern int MPI_Comm_compare __ARGS((MPI_Comm, MPI_Comm, int *));
extern int MPI_Comm_create __ARGS((MPI_Comm, MPI_Group, MPI_Comm *));
extern int MPI_Comm_disconnect __ARGS((MPI_Comm *));
extern int MPI_Comm_dup __ARGS((MPI_Comm, MPI_Comm *));
extern int MPI_Comm_free __ARGS((MPI_Comm *));
extern int MPI_Comm_group __ARGS((MPI_Comm, MPI_Group *));
extern int MPI_Comm_rank __ARGS((MPI_Comm, int *));
extern int MPI_Comm_remote_group __ARGS((MPI_Comm, MPI_Group *));
extern int MPI_Comm_remote_size __ARGS((MPI_Comm, int *));
extern int MPI_Comm_size __ARGS((MPI_Comm, int *));
extern int MPI_Comm_split __ARGS((MPI_Comm, int, int, MPI_Comm *));
extern int MPI_Comm_test_inter __ARGS((MPI_Comm, int *));
extern int MPI_Connect __ARGS((char *, MPI_Info, int, MPI_Comm, MPI_Comm *));
extern int MPI_Dims_create __ARGS((int, int, int *));
extern int MPI_Errhandler_create __ARGS((MPI_Handler_function *,
				MPI_Errhandler *));
extern int MPI_Errhandler_free __ARGS((MPI_Errhandler *));
extern int MPI_Errhandler_get __ARGS((MPI_Comm, MPI_Errhandler *));
extern int MPI_Errhandler_set __ARGS((MPI_Comm, MPI_Errhandler));
extern int MPI_Error_class __ARGS((int, int *));
extern int MPI_Error_string __ARGS((int, char *, int *));
extern int MPI_Finalize __ARGS((void));
extern int MPI_Gather __ARGS((void *, int, MPI_Datatype, void *,
				int, MPI_Datatype, int, MPI_Comm));
extern int MPI_Gatherv __ARGS((void *, int, MPI_Datatype, void *,
				int *, int *, MPI_Datatype, int, MPI_Comm));
extern int MPI_Get_count __ARGS((MPI_Status *, MPI_Datatype, int *));
extern int MPI_Get_elements __ARGS((MPI_Status *, MPI_Datatype, int *));
extern int MPI_Get_processor_name __ARGS((char *, int *));
extern int MPI_Get_version __ARGS((int *, int *));
extern int MPI_Graph_create __ARGS((MPI_Comm, int, int *, int *,
				int, MPI_Comm *));
extern int MPI_Graph_get __ARGS((MPI_Comm, int, int, int *, int *));
extern int MPI_Graph_map __ARGS((MPI_Comm, int, int *, int *, int *));
extern int MPI_Graph_neighbors __ARGS((MPI_Comm, int, int, int *));
extern int MPI_Graph_neighbors_count __ARGS((MPI_Comm, int, int *));
extern int MPI_Graphdims_get __ARGS((MPI_Comm, int *, int *));
extern int MPI_Group_compare __ARGS((MPI_Group, MPI_Group, int *));
extern int MPI_Group_difference __ARGS((MPI_Group, MPI_Group, MPI_Group *));
extern int MPI_Group_excl __ARGS((MPI_Group, int, int *, MPI_Group *));
extern int MPI_Group_free __ARGS((MPI_Group *));
extern int MPI_Group_incl __ARGS((MPI_Group, int, int *, MPI_Group *));
extern int MPI_Group_intersection __ARGS((MPI_Group, MPI_Group, MPI_Group *));
extern int MPI_Group_range_excl __ARGS((MPI_Group, int,
				int [][3], MPI_Group *));
extern int MPI_Group_range_incl __ARGS((MPI_Group, int,
				int [][3], MPI_Group *));
extern int MPI_Group_rank __ARGS((MPI_Group, int *));
extern int MPI_Group_size __ARGS((MPI_Group, int *));
extern int MPI_Group_translate_ranks __ARGS((MPI_Group, int,
				int *, MPI_Group, int *));
extern int MPI_Group_union __ARGS((MPI_Group, MPI_Group, MPI_Group *));
extern int MPI_Ibsend __ARGS((void *, int, MPI_Datatype, int,
				int, MPI_Comm, MPI_Request *));
extern int MPI_Info_create __ARGS((MPI_Info *));
extern int MPI_Info_delete __ARGS((MPI_Info, char *));
extern int MPI_Info_dup __ARGS((MPI_Info, MPI_Info *));
extern int MPI_Info_free __ARGS((MPI_Info *));
extern int MPI_Info_get __ARGS((MPI_Info, char *, int, char *, int *));
extern int MPI_Info_get_nkeys __ARGS((MPI_Info, int *));
extern int MPI_Info_get_nthkey __ARGS((MPI_Info, int, char *));
extern int MPI_Info_get_valuelen __ARGS((MPI_Info, char *, int *, int *));
extern int MPI_Info_set __ARGS((MPI_Info, char *, char *));
extern int MPI_Init __ARGS((int *, char ***));
extern int MPI_Initialized __ARGS((int *));
extern int MPI_Intercomm_create __ARGS((MPI_Comm, int,
				MPI_Comm, int, int, MPI_Comm *));
extern int MPI_Intercomm_merge __ARGS((MPI_Comm, int, MPI_Comm *));
extern int MPI_Iprobe __ARGS((int, int, MPI_Comm, int *, MPI_Status *));
extern int MPI_Irecv __ARGS((void *, int, MPI_Datatype, int,
				int, MPI_Comm, MPI_Request *));
extern int MPI_Irsend __ARGS((void *, int, MPI_Datatype, int,
				int, MPI_Comm, MPI_Request *));
extern int MPI_Isend __ARGS((void *, int, MPI_Datatype, int,
				int, MPI_Comm, MPI_Request *));
extern int MPI_Issend __ARGS((void *, int, MPI_Datatype, int,
				int, MPI_Comm, MPI_Request *));
extern int MPI_Keyval_create __ARGS((MPI_Copy_function *,
				MPI_Delete_function *, int *, void *));
extern int MPI_Keyval_free __ARGS((int *));
extern int MPI_Name_get __ARGS((char *, MPI_Info, char *));
extern int MPI_Name_publish __ARGS((char *, MPI_Info, char *));
extern int MPI_Name_unpublish __ARGS((char *, char *));
extern int MPI_Op_create __ARGS((MPI_User_function *, int, MPI_Op *));
extern int MPI_Op_free __ARGS((MPI_Op *));
extern int MPI_Pack __ARGS((void *, int, MPI_Datatype, void *,
				int, int *, MPI_Comm));
extern int MPI_Pack_size __ARGS((int, MPI_Datatype, MPI_Comm, int *));
extern int MPI_Pcontrol __ARGS((int level, ...));
extern int MPI_Port_open __ARGS((MPI_Info, char *));
extern int MPI_Port_close __ARGS((char *));
extern int MPI_Probe __ARGS((int, int, MPI_Comm, MPI_Status *));
extern int MPI_Recv __ARGS((void *, int, MPI_Datatype, int,
				int, MPI_Comm, MPI_Status *));
extern int MPI_Recv_init __ARGS((void *, int, MPI_Datatype, int,
				int, MPI_Comm, MPI_Request *));
extern int MPI_Reduce __ARGS((void *, void *, int, MPI_Datatype,
				MPI_Op, int, MPI_Comm));
extern int MPI_Reduce_scatter __ARGS((void *, void *, int *,
				MPI_Datatype, MPI_Op, MPI_Comm));
extern int MPI_Request_free __ARGS((MPI_Request *));
extern int MPI_Rsend __ARGS((void *, int, MPI_Datatype, int, int, MPI_Comm));
extern int MPI_Rsend_init __ARGS((void *, int, MPI_Datatype, int,
				int, MPI_Comm, MPI_Request *));
extern int MPI_Scan __ARGS((void *, void *, int, MPI_Datatype,
				MPI_Op, MPI_Comm));
extern int MPI_Scatter __ARGS((void *, int, MPI_Datatype, void *,
				int, MPI_Datatype, int, MPI_Comm));
extern int MPI_Scatterv __ARGS((void *, int *, int *, MPI_Datatype, void *,
				int, MPI_Datatype, int, MPI_Comm));
extern int MPI_Send __ARGS((void *, int, MPI_Datatype, int, int, MPI_Comm));
extern int MPI_Send_init __ARGS((void *, int, MPI_Datatype, int,
				int, MPI_Comm, MPI_Request *));
extern int MPI_Sendrecv __ARGS((void *, int, MPI_Datatype, int, int, void *,
			int, MPI_Datatype, int, int, MPI_Comm, MPI_Status *));
extern int MPI_Sendrecv_replace __ARGS((void *, int, MPI_Datatype, int, int,
				int, int, MPI_Comm, MPI_Status *));
extern int MPI_Spawn __ARGS((char *, char **, int, MPI_Info, int,
			MPI_Comm, MPI_Comm *, int *));
extern int MPI_Spawn_multiple __ARGS((int, char **, char ***, int *,
				MPI_Info *, int, MPI_Comm, MPI_Comm *, int *));
extern int MPI_Ssend __ARGS((void *, int, MPI_Datatype, int, int, MPI_Comm));
extern int MPI_Ssend_init __ARGS((void *, int, MPI_Datatype, int,
				int, MPI_Comm, MPI_Request *));
extern int MPI_Start __ARGS((MPI_Request *));
extern int MPI_Startall __ARGS((int, MPI_Request *));
extern int MPI_Test __ARGS((MPI_Request *, int *, MPI_Status *));
extern int MPI_Test_cancelled __ARGS((MPI_Status *, int *));
extern int MPI_Testall __ARGS((int, MPI_Request *, int *, MPI_Status *));
extern int MPI_Testany __ARGS((int, MPI_Request *, int *,
				int *, MPI_Status *));
extern int MPI_Testsome __ARGS((int, MPI_Request *, int *,
				int *, MPI_Status *));
extern int MPI_Topo_test __ARGS((MPI_Comm, int *));
extern int MPI_Type_commit __ARGS((MPI_Datatype *));
extern int MPI_Type_contiguous __ARGS((int, MPI_Datatype, MPI_Datatype *));
extern int MPI_Type_extent __ARGS((MPI_Datatype, MPI_Aint *));
extern int MPI_Type_free __ARGS((MPI_Datatype *));
extern int MPI_Type_hindexed __ARGS((int, int *, MPI_Aint *,
				MPI_Datatype, MPI_Datatype *));
extern int MPI_Type_hvector __ARGS((int, int, MPI_Aint,
				MPI_Datatype, MPI_Datatype *));
extern int MPI_Type_indexed __ARGS((int, int *, int *,
				MPI_Datatype, MPI_Datatype *));
extern int MPI_Type_lb __ARGS((MPI_Datatype, MPI_Aint *));
extern int MPI_Type_size __ARGS((MPI_Datatype, int *));
extern int MPI_Type_struct __ARGS((int, int *, MPI_Aint *,
				MPI_Datatype *, MPI_Datatype *));
extern int MPI_Type_ub __ARGS((MPI_Datatype, MPI_Aint *));
extern int MPI_Type_vector __ARGS((int, int, int,
				MPI_Datatype, MPI_Datatype *));
extern int MPI_Unpack __ARGS((void *, int, int *, void *,
				int, MPI_Datatype, MPI_Comm));
extern int MPI_Wait __ARGS((MPI_Request *, MPI_Status *));
extern int MPI_Waitall __ARGS((int, MPI_Request *, MPI_Status *));
extern int MPI_Waitany __ARGS((int, MPI_Request *, int *, MPI_Status *));
extern int MPI_Waitsome __ARGS((int, MPI_Request *, int *,
				int *, MPI_Status *));
extern double MPI_Wtick __ARGS((void));
extern double MPI_Wtime __ARGS((void));

extern int MPI_DUP_FN __ARGS((MPI_Comm, int, void *, void *, void *, int*));

/*
 * profiling prototypes
 */
extern int PMPI_Abort __ARGS((MPI_Comm, int));
extern int PMPI_Accept __ARGS((char *, MPI_Info, int, MPI_Comm, MPI_Comm *));
extern int PMPI_Address __ARGS((void *, MPI_Aint *));
extern int PMPI_Allgather __ARGS((void *, int, MPI_Datatype, void *,
				int, MPI_Datatype, MPI_Comm));
extern int PMPI_Allgatherv __ARGS((void *, int, MPI_Datatype, void *,
				int *, int *, MPI_Datatype, MPI_Comm));
extern int PMPI_Allreduce __ARGS((void *, void *, int, MPI_Datatype,
				MPI_Op, MPI_Comm));
extern int PMPI_Alltoall __ARGS((void *, int, MPI_Datatype, void *,
				int, MPI_Datatype, MPI_Comm));
extern int PMPI_Alltoallv __ARGS((void *, int *, int *, MPI_Datatype, void *,
				int *, int *, MPI_Datatype, MPI_Comm));
extern int PMPI_Attr_delete __ARGS((MPI_Comm, int));
extern int PMPI_Attr_get __ARGS((MPI_Comm, int, void *, int *));
extern int PMPI_Attr_put __ARGS((MPI_Comm, int, void *));
extern int PMPI_Barrier __ARGS((MPI_Comm));
extern int PMPI_Bcast __ARGS((void *, int, MPI_Datatype, int, MPI_Comm));
extern int PMPI_Bsend __ARGS((void *, int, MPI_Datatype, int, int, MPI_Comm));
extern int PMPI_Bsend_init __ARGS((void *, int, MPI_Datatype, int,
				int, MPI_Comm, MPI_Request *));
extern int PMPI_Buffer_attach __ARGS((void *, int));
extern int PMPI_Buffer_detach __ARGS((void *, int *));
extern int PMPI_Cancel __ARGS((MPI_Request *));
extern int PMPI_Cart_coords __ARGS((MPI_Comm, int, int, int *));
extern int PMPI_Cart_create __ARGS((MPI_Comm, int, int *, int *,
				int, MPI_Comm *));
extern int PMPI_Cart_get __ARGS((MPI_Comm, int, int *, int *, int *));
extern int PMPI_Cart_map __ARGS((MPI_Comm, int, int *, int *, int *));
extern int PMPI_Cart_rank __ARGS((MPI_Comm, int *, int *));
extern int PMPI_Cart_shift __ARGS((MPI_Comm, int, int, int *, int *));
extern int PMPI_Cart_sub __ARGS((MPI_Comm, int *, MPI_Comm *));
extern int PMPI_Cartdim_get __ARGS((MPI_Comm, int *));
extern int PMPI_Comm_compare __ARGS((MPI_Comm, MPI_Comm, int *));
extern int PMPI_Comm_create __ARGS((MPI_Comm, MPI_Group, MPI_Comm *));
extern int PMPI_Comm_disconnect __ARGS((MPI_Comm *));
extern int PMPI_Comm_dup __ARGS((MPI_Comm, MPI_Comm *));
extern int PMPI_Comm_free __ARGS((MPI_Comm *));
extern int PMPI_Comm_group __ARGS((MPI_Comm, MPI_Group *));
extern int PMPI_Comm_rank __ARGS((MPI_Comm, int *));
extern int PMPI_Comm_remote_group __ARGS((MPI_Comm, MPI_Group *));
extern int PMPI_Comm_remote_size __ARGS((MPI_Comm, int *));
extern int PMPI_Comm_size __ARGS((MPI_Comm, int *));
extern int PMPI_Comm_split __ARGS((MPI_Comm, int, int, MPI_Comm *));
extern int PMPI_Comm_test_inter __ARGS((MPI_Comm, int *));
extern int PMPI_Connect __ARGS((char *, MPI_Info, int, MPI_Comm, MPI_Comm *));
extern int PMPI_Dims_create __ARGS((int, int, int *));
extern int PMPI_Errhandler_create __ARGS((MPI_Handler_function *,
				MPI_Errhandler *));
extern int PMPI_Errhandler_free __ARGS((MPI_Errhandler *));
extern int PMPI_Errhandler_get __ARGS((MPI_Comm, MPI_Errhandler *));
extern int PMPI_Errhandler_set __ARGS((MPI_Comm, MPI_Errhandler));
extern int PMPI_Error_class __ARGS((int, int *));
extern int PMPI_Error_string __ARGS((int, char *, int *));
extern int PMPI_Finalize __ARGS((void));
extern int PMPI_Gather __ARGS((void *, int, MPI_Datatype, void *,
				int, MPI_Datatype, int, MPI_Comm));
extern int PMPI_Gatherv __ARGS((void *, int, MPI_Datatype, void *,
				int *, int *, MPI_Datatype, int, MPI_Comm));
extern int PMPI_Get_count __ARGS((MPI_Status *, MPI_Datatype, int *));
extern int PMPI_Get_elements __ARGS((MPI_Status *, MPI_Datatype, int *));
extern int PMPI_Get_processor_name __ARGS((char *, int *));
extern int PMPI_Get_version __ARGS((int *, int *));
extern int PMPI_Graph_create __ARGS((MPI_Comm, int, int *, int *,
				int, MPI_Comm *));
extern int PMPI_Graph_get __ARGS((MPI_Comm, int, int, int *, int *));
extern int PMPI_Graph_map __ARGS((MPI_Comm, int, int *, int *, int *));
extern int PMPI_Graph_neighbors __ARGS((MPI_Comm, int, int, int *));
extern int PMPI_Graph_neighbors_count __ARGS((MPI_Comm, int, int *));
extern int PMPI_Graphdims_get __ARGS((MPI_Comm, int *, int *));
extern int PMPI_Group_compare __ARGS((MPI_Group, MPI_Group, int *));
extern int PMPI_Group_difference __ARGS((MPI_Group, MPI_Group, MPI_Group *));
extern int PMPI_Group_excl __ARGS((MPI_Group, int, int *, MPI_Group *));
extern int PMPI_Group_free __ARGS((MPI_Group *));
extern int PMPI_Group_incl __ARGS((MPI_Group, int, int *, MPI_Group *));
extern int PMPI_Group_intersection __ARGS((MPI_Group, MPI_Group, MPI_Group *));
extern int PMPI_Group_range_excl __ARGS((MPI_Group, int,
				int [][3], MPI_Group *));
extern int PMPI_Group_range_incl __ARGS((MPI_Group, int,
				int [][3], MPI_Group *));
extern int PMPI_Group_rank __ARGS((MPI_Group, int *));
extern int PMPI_Group_size __ARGS((MPI_Group, int *));
extern int PMPI_Group_translate_ranks __ARGS((MPI_Group, int,
				int *, MPI_Group, int *));
extern int PMPI_Group_union __ARGS((MPI_Group, MPI_Group, MPI_Group *));
extern int PMPI_Ibsend __ARGS((void *, int, MPI_Datatype, int,
				int, MPI_Comm, MPI_Request *));
extern int PMPI_Info_create __ARGS((MPI_Info *));
extern int PMPI_Info_delete __ARGS((MPI_Info, char *));
extern int PMPI_Info_dup __ARGS((MPI_Info, MPI_Info *));
extern int PMPI_Info_free __ARGS((MPI_Info *));
extern int PMPI_Info_get __ARGS((MPI_Info, char *, int, char *, int *));
extern int PMPI_Info_get_nkeys __ARGS((MPI_Info, int *));
extern int PMPI_Info_get_nthkey __ARGS((MPI_Info, int, char *));
extern int PMPI_Info_get_valuelen __ARGS((MPI_Info, char *, int *, int *));
extern int PMPI_Info_set __ARGS((MPI_Info, char *, char *));
extern int PMPI_Init __ARGS((int *, char ***));
extern int PMPI_Initialized __ARGS((int *));
extern int PMPI_Intercomm_create __ARGS((MPI_Comm, int,
				MPI_Comm, int, int, MPI_Comm *));
extern int PMPI_Intercomm_merge __ARGS((MPI_Comm, int, MPI_Comm *));
extern int PMPI_Iprobe __ARGS((int, int, MPI_Comm, int *, MPI_Status *));
extern int PMPI_Irecv __ARGS((void *, int, MPI_Datatype, int,
				int, MPI_Comm, MPI_Request *));
extern int PMPI_Irsend __ARGS((void *, int, MPI_Datatype, int,
				int, MPI_Comm, MPI_Request *));
extern int PMPI_Isend __ARGS((void *, int, MPI_Datatype, int,
				int, MPI_Comm, MPI_Request *));
extern int PMPI_Issend __ARGS((void *, int, MPI_Datatype, int,
				int, MPI_Comm, MPI_Request *));
extern int PMPI_Keyval_create __ARGS((MPI_Copy_function *,
				MPI_Delete_function *, int *, void *));
extern int PMPI_Keyval_free __ARGS((int *));
extern int PMPI_Name_get __ARGS((char *, MPI_Info, char *));
extern int PMPI_Name_publish __ARGS((char *, MPI_Info, char *));
extern int PMPI_Name_unpublish __ARGS((char *, char *));
extern int PMPI_Op_create __ARGS((MPI_User_function *, int, MPI_Op *));
extern int PMPI_Op_free __ARGS((MPI_Op *));
extern int PMPI_Pack __ARGS((void *, int, MPI_Datatype, void *,
				int, int *, MPI_Comm));
extern int PMPI_Pack_size __ARGS((int, MPI_Datatype, MPI_Comm, int *));
extern int PMPI_Pcontrol __ARGS((int level, ...));
extern int PMPI_Port_open __ARGS((MPI_Info, char *));
extern int PMPI_Port_close __ARGS((char *));
extern int PMPI_Probe __ARGS((int, int, MPI_Comm, MPI_Status *));
extern int PMPI_Recv __ARGS((void *, int, MPI_Datatype, int,
				int, MPI_Comm, MPI_Status *));
extern int PMPI_Recv_init __ARGS((void *, int, MPI_Datatype, int,
				int, MPI_Comm, MPI_Request *));
extern int PMPI_Reduce __ARGS((void *, void *, int, MPI_Datatype,
				MPI_Op, int, MPI_Comm));
extern int PMPI_Reduce_scatter __ARGS((void *, void *, int *,
				MPI_Datatype, MPI_Op, MPI_Comm));
extern int PMPI_Request_free __ARGS((MPI_Request *));
extern int PMPI_Rsend __ARGS((void *, int, MPI_Datatype, int, int, MPI_Comm));
extern int PMPI_Rsend_init __ARGS((void *, int, MPI_Datatype, int,
				int, MPI_Comm, MPI_Request *));
extern int PMPI_Scan __ARGS((void *, void *, int, MPI_Datatype,
				MPI_Op, MPI_Comm));
extern int PMPI_Scatter __ARGS((void *, int, MPI_Datatype, void *,
				int, MPI_Datatype, int, MPI_Comm));
extern int PMPI_Scatterv __ARGS((void *, int *, int *, MPI_Datatype, void *,
				int, MPI_Datatype, int, MPI_Comm));
extern int PMPI_Send __ARGS((void *, int, MPI_Datatype, int, int, MPI_Comm));
extern int PMPI_Send_init __ARGS((void *, int, MPI_Datatype, int,
				int, MPI_Comm, MPI_Request *));
extern int PMPI_Sendrecv __ARGS((void *, int, MPI_Datatype, int, int, void *,
			int, MPI_Datatype, int, int, MPI_Comm, MPI_Status *));
extern int PMPI_Sendrecv_replace __ARGS((void *, int, MPI_Datatype, int, int,
				int, int, MPI_Comm, MPI_Status *));
extern int PMPI_Spawn __ARGS((char *, char **, int, MPI_Info, int,
				MPI_Comm, MPI_Comm *, int *));
extern int PMPI_Spawn_multiple __ARGS((int, char **, char ***, int *,
				MPI_Info *, int, MPI_Comm, MPI_Comm *, int *));
extern int PMPI_Ssend __ARGS((void *, int, MPI_Datatype, int, int, MPI_Comm));
extern int PMPI_Ssend_init __ARGS((void *, int, MPI_Datatype, int,
				int, MPI_Comm, MPI_Request *));
extern int PMPI_Start __ARGS((MPI_Request *));
extern int PMPI_Startall __ARGS((int, MPI_Request *));
extern int PMPI_Test __ARGS((MPI_Request *, int *, MPI_Status *));
extern int PMPI_Test_cancelled __ARGS((MPI_Status *, int *));
extern int PMPI_Testall __ARGS((int, MPI_Request *, int *, MPI_Status *));
extern int PMPI_Testany __ARGS((int, MPI_Request *, int *,
				int *, MPI_Status *));
extern int PMPI_Testsome __ARGS((int, MPI_Request *, int *,
				int *, MPI_Status *));
extern int PMPI_Topo_test __ARGS((MPI_Comm, int *));
extern int PMPI_Type_commit __ARGS((MPI_Datatype *));
extern int PMPI_Type_contiguous __ARGS((int, MPI_Datatype, MPI_Datatype *));
extern int PMPI_Type_extent __ARGS((MPI_Datatype, MPI_Aint *));
extern int PMPI_Type_free __ARGS((MPI_Datatype *));
extern int PMPI_Type_hindexed __ARGS((int, int *, MPI_Aint *,
				MPI_Datatype, MPI_Datatype *));
extern int PMPI_Type_hvector __ARGS((int, int, MPI_Aint,
				MPI_Datatype, MPI_Datatype *));
extern int PMPI_Type_indexed __ARGS((int, int *, int *,
				MPI_Datatype, MPI_Datatype *));
extern int PMPI_Type_lb __ARGS((MPI_Datatype, MPI_Aint *));
extern int PMPI_Type_size __ARGS((MPI_Datatype, int *));
extern int PMPI_Type_struct __ARGS((int, int *, MPI_Aint *,
				MPI_Datatype *, MPI_Datatype *));
extern int PMPI_Type_ub __ARGS((MPI_Datatype, MPI_Aint *));
extern int PMPI_Type_vector __ARGS((int, int, int,
				MPI_Datatype, MPI_Datatype *));
extern int PMPI_Unpack __ARGS((void *, int, int *, void *,
				int, MPI_Datatype, MPI_Comm));
extern int PMPI_Wait __ARGS((MPI_Request *, MPI_Status *));
extern int PMPI_Waitall __ARGS((int, MPI_Request *, MPI_Status *));
extern int PMPI_Waitany __ARGS((int, MPI_Request *, int *, MPI_Status *));
extern int PMPI_Waitsome __ARGS((int, MPI_Request *, int *,
				int *, MPI_Status *));
extern double PMPI_Wtick __ARGS((void));
extern double PMPI_Wtime __ARGS((void));

/*
 * LAM/MPI extensions
 */
extern int MPIL_Spawn __ARGS((MPI_Comm, char *, int, MPI_Comm *));
extern int MPIL_Comm_parent __ARGS((MPI_Comm *));
extern int MPIL_Universe_size __ARGS((int *));
extern int MPIL_Comm_id __ARGS((MPI_Comm, int *));
extern int MPIL_Comm_gps __ARGS((MPI_Comm, int, int *, int *));
extern int MPIL_Type_id __ARGS((MPI_Datatype, int *));
extern int MPIL_Trace_on __ARGS((void));
extern int MPIL_Trace_off __ARGS((void));
extern int MPIL_Signal __ARGS((MPI_Comm, int, int));

extern int PMPIL_Spawn __ARGS((MPI_Comm, char *, int, MPI_Comm *));

/*
 * backward compatibility
 */
extern int MPI_Comm_get_contextid __ARGS((MPI_Comm, int *));

#ifdef __cplusplus
}
#endif

#endif	/* _MPI_H */
