/*
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	GDB/RBD
 *
 *	$Log:	lamnet.h,v $
 * Revision 6.1.1.1  97/01/21  09:56:36  nevin
 * Include "lam.h".
 * 
 * Revision 6.1  96/11/23  21:55:08  nevin
 * Ohio Release
 * 
 * Revision 6.0  96/02/29  13:53:38  gdburns
 * Ohio Release
 * 
 *	Function:	- LAM network description
 */

#ifndef _LAMNET
#define _LAMNET

#include <sys/types.h>
#include <netinet/in.h>

#include "lam.h"

/*
 * default filenames
 */
#define DEFFBHOST	"bhost.def"	/* default host file */

/*
 * default search paths
 */
#ifndef DEFPBHOST
#define DEFPBHOST	"/tmp/lam/boot"	/* default boot directory */
#endif

/*
 * default tools
 */
#define DEFTHBOOT	"hboot"
#define DEFTTKILL	"tkill"
#define DEFTWIPE	"wipe"

/*
 * node description
 */
struct lamnode {			/* node information */
	int4		lnd_nodeid;	/* node identifier */
	int4		lnd_type;	/* node type */
	int		lnd_bootport;	/* booting port # */
	char		*lnd_hname;	/* host name */
	char		*lnd_uname;	/* user name */
	struct sockaddr_in
			lnd_addr;	/* internet address */
};

/*
 * prototypes
 */
#ifndef __ARGS
#if __STDC__ || defined(c_plusplus) || defined(__cplusplus)
#define __ARGS(a)	a
#else
#define __ARGS(a)	()
#endif
#endif

#ifdef __cplusplus
extern "C" {
#endif

extern int		lamnet_dups __ARGS((struct lamnode *lamnet,
					int nlamnet, int *pdup));
extern int		lamnet_findhosts __ARGS((struct lamnode *lamnet,
					int nlamnet));
extern int		lamnet_findorig __ARGS((struct lamnode *lamnet,
					int nlamnet));

#ifdef __cplusplus
}
#endif

#endif	/* _LAMNET */
