/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	GDB
 *
 *	$Id: kio.h,v 6.1 96/11/23 21:54:59 nevin Rel $
 *
 *	Function:	- defines templates and constants for the
 *			  Kernel Input Output block
 */

#ifndef _KIO
#define _KIO

#include <kreq.h>
#include <ksignal.h>
#include <ktrace.h>
#include <portable.h>
#include <rreq.h>

#define MAXRCACHE	29		/* max # of cached routes */
#define	TNEXIT		32		/* maximum number of exit routines */

/*
 * Runtime Flags
 */
#define RTF_KERNEL	0x00001		/* attached to kernel? */
#define RTF_KENYA	0x00002		/* attached to kenya? */
#define RTF_SYSGEN	0x00008		/* system process? */
#define RTF_WAIT	0x00010		/* background process? */
#define RTF_MPIGER	0x00020		/* guaranteed resources protocol */
#define RTF_DEBUG	0x00040		/* for debuggers */
#define RTF_MPIC2C	0x00080		/* direct client to client comm. */
#define RTF_TRACE	0x00100		/* traced process? */
#define RTF_TRSWITCH	0x00200		/* trace on/off switch */
#define RTF_TRON	0x00300		/* comb. of TRACE & TRSWITCH */
#define RTF_MPI		0x00400		/* I am an MPI process. */
#define RTF_FLAT	0x00800		/* loaded by flatd? */
#define RTF_MPIRUN	0x01000		/* started by mpirun? */
#define RTF_HOMOG	0x02000		/* homogeneous cluster */
#define RTF_APPWD	0x04000		/* change directory to applications */
#define RTF_IO		0x08000		/* stdio redirection */
#define RTF_PFDIO	0x10000		/* stdio via passed file descriptors */
#define RTF_TTYOUT	0x20000		/* stdout is ultimately a tty */
#define RTF_CWD		0x40000		/* change directory to cwd */

/*
 * Kernel Interface
 */
struct kio_t {
	int4		ki_priority;	/* my kernel process priority */
	int4		ki_rtf;		/* Run Time Flags */
	int4		ki_pid;		/* kernel registered process ID */
	int4		ki_signal;	/* pending signals */
	int4		ki_sigmask;	/* signal masks */
	int4		ki_sigretry;	/* flags to retry after EINTR */
	int4		ki_index;	/* fast identification in kernel */
	int4		ki_nodeid;	/* my node identifier */
	int4		ki_origin;	/* origin node identifier */
	int4		ki_jobid;	/* job identifier */
	int4		ki_ionode;	/* standard io node */
	int4		ki_stdin;	/* standard input descriptor */
	int4		ki_stdout;	/* standard output descriptor */
	int4		ki_stderr;	/* standard error descriptor */
/*
 * Signal Handling Table
 */
	void		((*(ki_sig_handlers[TNSIG]))());
	void		((*(ki_sig_default[TNSIG]))());
/*
 * at exit table
 */
	void		((*(ki_exit[TNEXIT]))());
	char		*ki_arg[TNEXIT];
/*
 * route cache
 */
	struct route	ki_route[MAXRCACHE];
/*
 * trace support
 */
	struct trhead	*ki_trhead;	/* trace buffer headers */
	int4		ki_trcurr;	/* current trace buffer index */
	int4		ki_tid;		/* trace process identifier */

	int4		ki_world;	/* expected world population */
	int4		ki_parent;	/* parent group population */
/*
 * debug support
 */
	int4		ki_fyi[KNFYI];	/* debugging information */
	double		ki_blktime;	/* time spent blocking */
};

#endif
