/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD/GDB
 *
 *	$Id: app_schema.h,v 6.1.1.1 97/01/21 09:55:20 nevin Exp $
 * 
 *	Function:	- application schema templates and constants
 */

#ifndef _APPSCHEMA
#define _APPSCHEMA

#include "all_list.h"
#include "app_mgmt.h"
#include "lam.h"

/*
 * GER (Guaranteed Envelope Resources)
 */
#ifndef MPI_GER
#define MPI_GER			8
#endif

/*
 * structures
 */
struct apparg {
	int4		apa_refcount;		/* reference count */
	int4		apa_argc;		/* # cmd line args */
	char		**apa_argv;		/* cmd line args */
};

struct aschema {
	int4		asc_srcnode;		/* binary source node */
	int4		asc_node;		/* single target node */
	int4		asc_proc_cnt;		/* # processes this entry */
	int4		asc_errno;		/* error code */
	LIST *		asc_nodelist;		/* nodes this entry */
	struct apparg *	asc_args;		/* cmd line args */
};

/*
 * prototypes
 */
#ifndef __ARGS
#if __STDC__ || defined(c_plusplus) || defined(__cplusplus)
#define __ARGS(a)	a
#else
#define __ARGS(a)	()
#endif
#endif

#ifdef __cplusplus
extern "C" {
#endif

extern LIST *		asc_bufparse __ARGS((char *buf, int size, int *pl));
extern LIST *		asc_parse __ARGS((const char *file, int *pl));
extern LIST *		asc_schedule __ARGS((LIST *ascparse));
extern void		asc_free __ARGS((LIST *ap));
extern int		asc_run __ARGS((LIST *ap, int np, int4 rtf, int v,
					int e, struct _gps *p));
extern int		asc_ger __ARGS((LIST *ap, int e));

#ifdef __cplusplus
}
#endif

#endif	/* _APPSCHEMA */
