/*
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	GDB
 *
 *	$Id: app_mgmt.h,v 6.1.1.1 97/01/21 09:54:15 nevin Exp $
 *
 *	Function:	- running application management
 */

#ifndef _APP_MGMT_H
#define _APP_MGMT_H

#include "lam.h"

/*
 * LAM constants & macros
 */
#define LAM_GPSCMP(p1, p2)	(((p1)->gps_node < (p2)->gps_node) ? -1 : \
				(((p1)->gps_node > (p2)->gps_node) ? 1 : \
				(((p1)->gps_idx < (p2)->gps_idx) ? -1 : \
				(((p1)->gps_idx > (p2)->gps_idx) ? 1 : \
				(((p1)->gps_pid < (p2)->gps_pid) ? -1 : \
				(((p1)->gps_pid > (p2)->gps_pid) ? 1 : 0))))))

/*
 * Global Positioning System for running processes
 */
struct _gps {
	int4		gps_node;		/* node ID */
	int4		gps_pid;		/* process ID */
	int4		gps_idx;		/* process index */
	int4		gps_grank;		/* glob. rank in loc. world */
};

/*
 * prototypes
 */
#ifndef __ARGS
#if __STDC__ || defined(c_plusplus) || defined(__cplusplus)
#define __ARGS(a)	a
#else
#define __ARGS(a)	()
#endif
#endif

#ifdef __cplusplus
extern "C" {
#endif

extern int		app_doom __ARGS((int app_n, struct _gps *app));
extern int		app_sendprocs __ARGS((int np, struct _gps *w));

#ifdef __cplusplus
}
#endif

#endif	/* _APP_MGMT_H */
