/*
 *	Ohio Trollius
 *	Copyright 1994 The Ohio State University
 *	RBD
 *
 *	$Log:	bootsockio.c,v $
 * Revision 6.1  96/11/23  19:57:52  nevin
 * Ohio Release
 * 
 * Revision 6.0  96/02/29  13:46:29  gdburns
 * Ohio Release
 * 
 * Revision 5.2  94/08/22  13:56:59  gdburns
 * Ohio Release
 * 
 * Revision 5.1  94/05/18  10:56:40  gdburns
 * Ohio Release
 * 
 * Revision 2.3  94/04/22  12:34:56  gdburns
 * Ohio Release
 * 
 * Revision 2.2.1.4  94/01/12  13:58:21  raja
 * Exclude nodeid from coordinate exchange.
 * 
 * Revision 2.2.1.3  93/10/15  14:03:35  raja
 * Add support for dl_inet UDP port.
 * 
 * Revision 2.2.1.2  93/07/20  16:44:27  raja
 * Change host address to 4 unsigned bytes.
 * 
 * Revision 2.2.1.1  93/07/09  15:43:42  raja
 * Modify to support host network address, not hostname.
 * 
 * Revision 2.2  93/05/04  14:35:27  raja
 * pre-release to 2.3
 * 
 *	Function:	- OTB booting socket I/O functions
 *				- readsockint4(): read an int4 from a socket
 *				- writesockint4(): read an int4 to a socket
 *				- readcltcoord(): read client nodeid/port #
 *				- readcltnbr(): read client neighbour info
 *				- writecltcoord(): write client nodeid/port #
 *				- writecltnbr(): write client neighbour info
 */

#include <errno.h>
#include <portable.h>
#include <t_types.h>
#include <typical.h>

/*
 * external functions
 */
extern int		mread();
extern int		mwrite();

/*
 *	readsockint4
 *
 *	Function:	- read a 32-bit integer from a socket
 *			- handles byte ordering issue
 *	Accepts:	- socket
 *			- ptr to integer
 *	Returns:	- 0 or ERROR
 */
int
readsockint4(sock, pdata)

int			sock;
int4			*pdata;

{
	int4		data;
	int		ret;

	ret = mread(sock, (char *) &data, sizeof(int4));
	if (ret < sizeof(int4)) {
		errno = (ret < 0) ? errno : EIO;
		return(ERROR);
	}

	*pdata = ttol(data);
	return(0);
}

/*
 *	writesockint4
 *
 *	Function:	- write a 32-bit integer to a socket
 *			- handles byte ordering issue
 *	Accepts:	- socket
 *			- integer
 *	Returns:	- 0 or ERROR
 */
int
writesockint4(sock, data)

int			sock;
int4			data;

{
	int		ret;

	data = ltot(data);
	ret = mwrite(sock, (char *) &data, sizeof(int4));
	if (ret < sizeof(int4)) {
		errno = (ret < 0) ? errno : EIO;
		return(ERROR);
	}

	return(0);
}

/*
 *	readcltcoord
 *
 *	Function:	- read client STREAM and UDP port numbers
 *	Accepts:	- socket
 *			- ptr to STREAM port #
 *			- ptr to UDP port #
 *	Returns:	- 0 or ERROR
 */
int
readcltcoord(sock, pstrport, pudpport)

int			sock;
int4			*pstrport;
int4			*pudpport;

{
	int4		status;

	if (readsockint4(sock, &status)) {
		return(ERROR);
	}

	if (status) {
		errno = status;
		return(ERROR);
	}

	if (readsockint4(sock, pstrport)) {
		return(ERROR);
	}

	if (readsockint4(sock, pudpport)) {
		return(ERROR);
	}

	return(0);
}

/*
 *	writecltcoord
 *
 *	Function:	- write client STREAM and UDP port numbers
 *			- called by the booted client
 *	Accepts:	- socket
 *			- STREAM port #
 *			- UDP port #
 *	Returns:	- 0 or ERROR
 */
int
writecltcoord(sock, strport, udpport)

int			sock;
int4			strport;
int4			udpport;

{
	if (writesockint4(sock, INT4_NIL)) {
		return(ERROR);
	}

	if (writesockint4(sock, strport)) {
		return(ERROR);
	}

	if (writesockint4(sock, udpport)) {
		return(ERROR);
	}

	return(0);
}

/*
 *	readcltnbr
 *
 *	Function:	- read client neighbour <link index, hostaddr, port>
 *	Accepts:	- socket
 *			- ptr link index
 *			- ptr host address (4 bytes, in network byte order)
 *			- ptr port number
 *	Returns:	- 0 or ERROR
 */
int
readcltnbr(sock, plink, phostaddr, pport)

int			sock;
int4			*plink;
unsigned char		*phostaddr;
int4			*pport;

{
	int		ret;

	if (readsockint4(sock, plink)) {
		return(ERROR);
	}

	ret = mread(sock, (char *) phostaddr, 4);
	if (ret < 4) {
		errno = (ret < 0) ? errno : EIO;
		return(ERROR);
	}

	if (readsockint4(sock, pport)) {
		return(ERROR);
	}

	return(0);
}

/*
 *	writecltnbr
 *
 *	Function:	- write client neighbour <link index, hostaddr, port>
 *			- called by the booting server
 *	Accepts:	- socket
 *			- link index
 *			- host address (4 bytes, in network byte order)
 *			- port number
 *	Returns:	- 0 or ERROR
 */
int
writecltnbr(sock, link, hostaddr, port)

int			sock;
int4			link;
unsigned char		*hostaddr;
int4			port;

{
	int		ret;

	if (writesockint4(sock, link)) {
		return(ERROR);
	}

	ret = mwrite(sock, (char *) hostaddr, 4);
	if (ret < 4) {
		errno = (ret < 0) ? errno : EIO;
		return(ERROR);
	}

	if (writesockint4(sock, port)) {
		return(ERROR);
	}

	return(0);
}
