/*
 *	Software for Humanity
 *	Public Domain
 *	RBD
 *
 *	This program is freely distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 *	$Id: all_squeue.c,v 6.1 96/11/23 19:57:47 nevin Rel $
 * 
 *	Function:	- generic queue management code
 *			- fully static version
 *				- aqs_init(): create a queue
 *			- other functions macro'ed to the dynamic version
 */

#include <errno.h>

#include <all_queue.h>
#include <portable.h>

/*
 *	aqs_init
 *
 *	Function:	- creates a static queue
 *	Accepts:	- size of queue
 *			- size of queue element
 *			- queue array
 *			- static queue descriptor
 *	Returns:	- static queue descriptor or NULL
 */
SQUEUE *
aqs_init(size, elemsize, queue, aqsd)

int4			size;
int4			elemsize;
void			*queue;
SQUEUE			*aqsd;

{
	if ((size <= 0) || (elemsize <= 0)) {
		errno = EINVAL;
		return((SQUEUE *) 0);
	}
/*
 * Initialize the queue descriptor.
 */
	aqsd->aq_maxnelem = size;
	aqsd->aq_elemsize = elemsize;
	aqsd->aq_nelem = 0;
	aqsd->aq_first = 0;
	aqsd->aq_last = 0;
	aqsd->aq_queue = queue;

	return(aqsd);
}
