/*
 *	Ohio Trollius
 *	Copyright 1994 The Ohio State University
 *	GDB
 *
 *	$Log:	kkill.c,v $
 * Revision 6.1  96/11/23  18:44:50  nevin
 * Ohio Release
 * 
 * Revision 6.0  96/02/29  13:32:54  gdburns
 * Ohio Release
 * 
 * Revision 5.2.1.1  96/01/12  21:41:50  gdburns
 * Remove port extension on kernel entry.
 * 
 * Revision 5.2  94/08/22  13:50:45  gdburns
 * Ohio Release
 * 
 * Revision 5.1.1.2  94/08/19  16:03:05  raja
 * Add SCO support.
 * 
 * Revision 5.1.1.1  94/08/18  11:08:18  gdburns
 * overhaul for new kernel
 * 
 * Revision 5.1  94/05/18  10:42:29  gdburns
 * Ohio Release
 * 
 * Revision 2.3  94/04/22  12:27:50  gdburns
 * Ohio Release
 * 
 *	Function:	- supports client cleanup by the kernel and by tkill(1)
 *			- OTB specific code
 */

#include <fcntl.h>
#include <signal.h>
#include <stdio.h>

#include <kreq.h>
#include <typical.h>

/*
 * global functions
 */
void			kkillall();
int			kkillclose();
int			kkillopen();
int			kkillrewrite();
int			kkillwrite();

/*
 * external variables
 */
extern struct kproc	*pready;
extern struct kproc	*pblock;

/*
 * local variables
 */
static FILE		*fp_kill;	/* kill file ptr */
static int		fd_kill;	/* kill file desc. */

/*
 *	kkillall
 *
 *	Function:	- catches SIGTERM and SIGHUP
 *			- kills all attached processes
 *			- exits
 */
void
kkillall()

{
	struct kproc	*p;

	for (p = pready; p; p = p->kp_next) {

		if (!(p->kp_flags & KIPROC)) {
			kill(p->kp_pid, SIGCONT);
			kill(p->kp_pid, SIGHUP);
		}
	}

	for (p = pblock; p; p = p->kp_next) {

		if (!(p->kp_flags & KIPROC)) {
			kill(p->kp_pid, SIGCONT);
			kill(p->kp_pid, SIGHUP);
		}
	}

	exit(0);
}

/*
 *	kkillopen
 *
 *	Function:	- opens the kill file
 *			- locates the kill directory and constructs
 *			  the full kill pathname by appending the
 *			  userid to the kill directory
 *			- writes the kernel's own pid in the first
 *			  entry of the kill file
 *	Accepts:	- kill filename
 *	Returns:	- 0 or LAMERROR
 */
int
kkillopen(f_kill)

char			*f_kill;

{
	fd_kill = open(f_kill, O_WRONLY | O_CREAT | O_EXCL, 0200);

	if (fd_kill < 0) {
		return(LAMERROR);
	}

	fp_kill = fdopen(fd_kill, "w");

	if (! fp_kill) {
		return(LAMERROR);
	}

	setvbuf(fp_kill, (char *) 0, _IOLBF, 0);

	if (fprintf(fp_kill, "%d\n", getpid()) == EOF) {
		return(LAMERROR);
	}

	if (chmod(f_kill, 0644)) {
		return(LAMERROR);
	}

	return(0);
}

/*
 *	kkillwrite
 *
 *	Function:	- writes pid into lock file
 *	Accepts:	- pid
 *	Returns:	- 0 or LAMERROR
 */
int
kkillwrite(pid)

int4			pid;

{
	if (fprintf(fp_kill, "%d\n", pid) == EOF) {
		return(LAMERROR);
	} else {
		return(0);
	}
}

/*
 *	kkillrewrite
 *
 *	Function:	- rewrites entire kill file from current process list
 *	Accepts:	- kernel process table
 *	Returns:	- 0 or LAMERROR
 */
int
kkillrewrite(kptable)

struct kproc		kptable[];

{
	int		i;
/*
 * Rewind the stdio descriptor.
 */
	rewind(fp_kill);
/*
 * Write the kernel pid first.
 */
	if (fprintf(fp_kill, "%d\n", getpid()) == EOF) {
		return(LAMERROR);
	}
/*
 * Write every current client pid.
 */
	for (i = 0; i < KPMAX; ++i) {

		if ((kptable[i].kp_state != KSFREE) &&
				!(kptable[i].kp_flags & KIPROC)) {

			if (fprintf(fp_kill, "%d\n", kptable[i].kp_pid)
					== EOF) {
				return(LAMERROR);
			}
		}
	}
/*
 * Truncate file to new length.
 */
#ifdef SCO
	if (chsize(fd_kill, ftell(fp_kill))) {
#else
	if (ftruncate(fd_kill, ftell(fp_kill))) {
#endif
		return(LAMERROR);
	}

	return(0);
}

/*
 *	kkillclose
 *
 *	Function:	- Flush and close the kill file.
 *	Returns:	- 0 or LAMERROR
 */
int
kkillclose()

{
	if (fclose(fp_kill) == EOF) {
		return(LAMERROR);
	} else {
		return(0);
	}
}
