/*
 *	Ohio Trollius
 *	Copyright 1995 The Ohio State University
 *	GDB
 *
 *	$Log:	fl_main.c,v $
 * Revision 6.1  96/11/23  19:29:56  nevin
 * Ohio Release
 * 
 * Revision 6.0  96/02/29  13:31:24  gdburns
 * Ohio Release
 * 
 * Revision 5.2.1.1  96/02/10  15:24:50  gdburns
 * Catch tkill/kernel termination and clean up.
 * 
 * Revision 5.2  94/08/22  13:49:20  gdburns
 * Ohio Release
 * 
 * Revision 2.3  94/04/22  12:27:27  gdburns
 * Ohio Release
 * 
 *	Function:	- flat storage server
 */

#include <signal.h>

#include <kreq.h>
#include <priority.h>

/*
 * external functions
 */
extern void		(*(_lam_signal()))();
extern void		flwipe();

/*
 * local functions
 */
static void		flbail();


main(argc, argv)

int			argc;
char			*argv[];

{
	_lam_signal(SIGHUP, flbail);
/*
 * Attach to kernel.
 */
	if (kinit(PRDAEMON)) lampanic("flatd (kinit)");
/*
 * Initialize.
 */
	fl_init(&argc, argv);
/*
 * server loop
 */
	for (;;) {

		if (!flatd()) {
			kexit(1);
			break;
		}
	}

	return(0);
}

/*
 *	flbail
 *
 *	Function:	- cleanup before exiting
 */
static void
flbail()

{
	flwipe();
	exit(0);
}
