/*
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	GDB
 *
 *	$Id: lamclean.c,v 6.1.1.2 97/03/28 10:50:09 nevin Exp $
 *
 *	Function:	- command to clean out several daemons on all nodes
 */

#include <stdio.h>
#include <stdlib.h>

#include <args.h>
#include <debug.h>
#include <freq.h>
#include <ksignal.h>
#include <net.h>
#include <preq.h>
#include <priority.h>
#include <terror.h>
#include <trreq.h>
#include <typical.h>

/*
 * local functions
 */
static void		help();


main(argc, argv)

int			argc;
char			*argv[];

{
	int4		*all;		/* array of all node IDs */
	int4		i;
	int4		nall;		/* count of all nodes */
	int		fl_verbose;	/* verbosity flag */
/*
 * Parse command-line arguments.
 */
	validopts("hv");

	if (do_args(&argc, argv) || (argc != 1)) {
		fprintf(stderr, "lamclean [-hv]\n");
		exit(LAM_EEXIT);
	}

	if (opt_taken('h')) {
		help();
		exit(0);
	}

	fl_verbose = opt_taken('v');
/*
 * Initialize and attach to Trollius kernel.
 */
	if (kinit(PRCMD)) {
		terror("lamclean (kinit)");
		exit(LAM_EEXIT);
	}
/*
 * Get an array of all node IDs.
 */
	nall = getnall();
	all = (int4 *) malloc((unsigned) (nall * sizeof(int4)));

	if (all == 0) lamfail("lamclean (malloc)");

	if (getall(all, nall)) lamfail("lamclean (getall)");
/*
 * Doom all appl processes.
 */
	if (fl_verbose) nodespin_init("killing processes,");

	for (i = 0; i < nall; ++i) {

		if (fl_verbose) nodespin_next(all[i]);

		if (rpdoom(all[i], SELECT_APPL, 0, SIGUDIE)) {
			lamfail("lamclean (rpdoom)");
		}
	}
/*
 * Reset file daemons.
 */
	if (fl_verbose) {
		nodespin_end();
		nodespin_init("closing files,");
	}

	for (i = 0; i < nall; ++i) {

		if (fl_verbose) nodespin_next(all[i]);

		if (rfrmfd(all[i], NOTFD)) {
			lamfail("lamclean (rfrmfd)");
		}
	}
/*
 * Reset trace deamons.
 */
	if (fl_verbose) {
		nodespin_end();
		nodespin_init("sweeping traces,");
	}

	for (i = 0; i < nall; ++i) {

		if (fl_verbose) nodespin_next(all[i]);

		if (lam_rtrsweep(all[i], TRANYLIST)) {
			lamfail("lamclean (lam_rtrsweep)");
		}
	}
/*
 * Reset buffers.
 */
	sleep(1);
	if (fl_verbose) {
		nodespin_end();
		nodespin_init("sweeping messages,");
	}

	for (i = 0; i < nall; ++i) {

		if (fl_verbose) nodespin_next(all[i]);

		if (rbfwipe(all[i])) {
			lamfail("lamclean (rbfwipe)");
		}
	}

	if (fl_verbose) nodespin_end();

	kexit(0);
	return(0);
}

/*
 *	help
 *
 *	Function:	- prints helpful information on this command
 */
static void
help()

{
	printf("\nSynopsis:	lamclean [options]\n");
	printf("\nDescription:	Clean up resources on all nodes.\n");
	printf("\nOptions:	-h\t\tPrint this help message.\n");
	printf("\t\t-v\t\tBe verbose.\n");
}
