/*
 *	Ohio Trollius
 *	Copyright 1993 The Ohio State University
 *	RBD
 *
 *	$Log:	ttime.c,v $
 * Revision 6.1  96/11/23  19:41:37  nevin
 * Ohio Release
 * 
 * Revision 6.0  96/02/29  13:07:15  gdburns
 * Ohio Release
 * 
 * Revision 5.2  94/08/22  13:35:11  gdburns
 * Ohio Release
 * 
 * Revision 5.1  94/05/18  10:35:26  gdburns
 * Ohio Release
 * 
 * Revision 2.3  94/04/22  12:08:26  gdburns
 * Ohio Release
 * 
 * Revision 2.2.1.1  93/07/21  21:59:50  gdburns
 * Remove SUCCESS.
 * Don't panic.
 * 
 * Revision 2.2  92/04/30  11:55:01  trillium
 * Ohio Release
 * 
 * Revision 2.1  91/03/20  13:36:00  gdburns
 * Ohio Release
 *
 *	Function:	- returns the contents of a system timer
 *			  expressed in seconds.
 *			- used primarily for recording elapsed 
 *			  time in the user code, in a portable
 *			  manner
 *			- The resolution is not guaranteed, as it
 *			  depends on the underlying hardware,
 *			  but the units (seconds) are
 *			  guaranteed.
 *			- This code is for OTB and uses the 
 *			  Unix(tm) timing support.
 *			- based on Trollius 2.0, Copyright 1990
 *			  The Ohio State University and Cornell
 *			  Research Foundation
 */

#include <sys/time.h>
#include <typical.h>

/*
 * external variables
 */
extern int	errno;

/*
 * ttime() returns the contents of the system timer (a measure
 * of time since an arbitrary but fixed point in time) expressed
 * in seconds. 
 */

double
ttime()

{
	struct	timeval	now;
	double		sec;
/*
 * Get the system time.
 */
	if (gettimeofday(&now, (struct timezone *) 0)) {
		return(0);
	}
/*
 * Return time in seconds.
 */
	sec = (double) now.tv_sec + (double) now.tv_usec / 1000000;
	return(sec);
}
