/*
 *	Ohio Trollius
 *	Copyright 1995 The Ohio State University
 *	RBD
 *
 *	$Log:	getinetaddr.c,v $
 * Revision 6.1  96/11/23  19:41:30  nevin
 * Ohio Release
 * 
 * Revision 6.0  96/02/29  13:07:11  gdburns
 * Ohio Release
 * 
 * Revision 5.2.1.1  96/02/07  01:46:18  gdburns
 * Set errno to EBADHOST.
 * 
 * Revision 5.2  94/08/22  13:33:01  gdburns
 * Ohio Release
 * 
 * Revision 5.1  94/05/18  10:35:17  gdburns
 * Ohio Release
 * 
 * Revision 2.3  94/04/22  12:08:23  gdburns
 * Ohio Release
 * 
 * Revision 2.2  93/10/15  13:22:48  raja
 * pre-release to 2.3
 * 
 *	Function:	- return the machine Internet address (OTB only)
 *			- address is a 4-byte array
 *	Accepts:	- machine name
 *			- 4-byte machine address (returned value)
 *	Returns:	- 0 or ERROR
 */

#include <netdb.h>
#include <portable.h>
#include <terror.h>
#include <typical.h>

int
getinetaddr(hostname, hostaddr)

char			*hostname;
unsigned char		*hostaddr;

{
	struct hostent	*p;
/*
 * Get host name entry.
 */
	p = gethostbyname(hostname);

	if (p == 0) {
		errno = EBADHOST;
		return(LAMERROR);
	}
/*
 * Copy the 4-byte Internet address.
 */
	if (p->h_length == 4) {
		memcpy((char *) hostaddr, p->h_addr, 4);
	}
/*
 * Not an Internet address.  Do nothing for now, it's an error.
 */
	else {
		errno = EINVAL;
		return(LAMERROR);
	}

	return(0);
}
