/*
   Controller.m
   
   Controller object for GNUstep Workspace

   Copyright (C) 1996 Free Software Foundation, Inc.
   
   Author:  Felipe A. Rodriguez <far@ix.netcom.com>
   Date: November 1998
   
   This file is part of the GNUstep GUI X/RAW Library.
   
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import <Foundation/NSAutoreleasePool.h>
#import <Foundation/NSFileManager.h>

#import <AppKit/AppKit.h>

#include "Controller.h"
#include "Browser.h"
#include "xbrowsercell.h"




@implementation Controller

- (void)applicationDidFinishLaunching:(NSNotification *)aNotification
{
NSWindow *window;
NSMatrix* matrix;
id browserCell;
NSSplitView *splitView;
NSRect winRect = {{100, 100}, {600, 600}};
NSRect browserRect = {{0, 0}, {570, 330}};
NSRect shelfRect = {{0, 350}, {570, 330}};
NSSize ms;
NSRect cvFrame;
ActiveBrowserDelegate *abd = [ActiveBrowserDelegate new];
unsigned int style = NSTitledWindowMask | NSClosableWindowMask				
					| NSMiniaturizableWindowMask | NSResizableWindowMask;

																// create main
	window = [[NSWindow alloc] initWithContentRect:winRect		// window
							   styleMask:style		
							   backing:NSBackingStoreRetained
							   defer:NO];

	browserCell = [[[xbrowsercell alloc] init] autorelease];
												 
	browser = [[Browser alloc] initWithFrame: browserRect];		// create the
	[browser setTitle: @"Column 0" ofColumn: 0];				// file browser
	[browser setDelegate: abd];
	[browser setMaxVisibleColumns: 1];
	[browser setCellPrototype:browserCell];
												  
	matrix = [[[NSMatrix alloc] initWithFrame:shelfRect			// create the
								mode:NSRadioModeMatrix			// shelf matrix
								prototype:browserCell
								numberOfRows:3
								numberOfColumns:6]
								autorelease];
	ms = [matrix cellSize];										// configure 
	ms.width = 80;												// shelf matrix
	ms.height = 70;
	[matrix setCellSize: ms];
	[matrix setDrawsBackground:YES];
	[matrix setBackgroundColor:[NSColor lightGrayColor]];

	cvFrame = [[window contentView] frame];						// configure 
	cvFrame.origin.x = 10;										// and create
	cvFrame.size.width -= (2 * cvFrame.origin.x);				// splitview    
	cvFrame.origin.y = 5;
	cvFrame.size.height -= (2 * cvFrame.origin.y);
	splitView = [[NSSplitView alloc] initWithFrame:cvFrame];
	[splitView setVertical:YES]; 
	[splitView addSubview: browser]; 
	[splitView addSubview: matrix]; 

	[[window contentView] addSubview: splitView];
	
	[window setTitle:@"Workspace"];
	[window display];
	[window orderFront:nil];
}

- (NSString *)path
{															// query browser
  	return [browser path];									// for it's path
}

- (void)method:menuCell
{
  	NSLog (@"method invoked from cell with title '%@'", [menuCell title]);
}

@end

