/*
   XRTextFieldCell.m

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author: Scott Christley
   Author: Ovidiu Predescu <ovidiu@bx.logicnet.ro>
   Date: February-March 1997
   Author:  Felipe A. Rodriguez <far@ix.netcom.com>
   Date: May 1998
   
   This file is part of the GNUstep GUI X/RAW Backend.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <config.h>
#include <stdlib.h>

#include <Foundation/NSAutoreleasePool.h>
#include <Foundation/NSString.h>
#include <Foundation/NSException.h>

#include <AppKit/NSColor.h>
#include <AppKit/NSFont.h>
#include <AppKit/NSCStringText.h>

#include <gnustep/xraw/XRCell.h>
#include <gnustep/xraw/XRFont.h>
#include <gnustep/xraw/XRTextFieldCell.h>
#include <gnustep/xraw/XRWindow.h>
#include <gnustep/xraw/XRDrawingEngine.h>




@implementation XRTextFieldCell

//
// Class methods
//
+ (void)initialize
{
	if (self == [XRTextFieldCell class])
		[self setVersion:1];								// Initial version
}

//
// Instance methods
//
- (void)drawInteriorWithFrame:(NSRect)frame inView:(NSView*)controlView
{
NSPoint point;
float textHeight;
float titleWidth;
  
	if (!contents)							
		return;

	control_view = controlView;						// Save last view drawn to

// 				We apply a clipping rectangle so save the graphics state
//  PSgsave();
// 				Translate the coordinate system to frame's origin 
//  PStranslate (frame.origin.x + xDist, frame.origin.y + yDist);
//	frame.origin = NSZeroPoint;

	frame.size.width -= 2 * xDist;
	frame.size.height -= 2 * yDist;

//  PSrectclip (0, 0, frame.size.width, frame.size.height);

	[text_color set];

	if (!cell_font)
		[NSException raise:NSInvalidArgumentException
				format:@"Request to draw a text cell but no font specified!"];

	[cell_font set];							// set the drawing engine font
	titleWidth = [cell_font widthOfString:contents];
						// height of bounding box for font (smallest rectangle
						// enclosing the shape obtained by superimposing  
						// all of the characters at the same origin [x,y])
	textHeight = [cell_font pointSize];
	frame.origin.y -= (textHeight / 2);

	switch (text_align) 					// Determine the x position of text
		{						 
		case NSLeftTextAlignment:	 		// ignore the justified and natural
    	case NSJustifiedTextAlignment:		// alignments
   		case NSNaturalTextAlignment:
      		point.x = frame.origin.x + xDist;
     		break;
    	case NSRightTextAlignment:
      		if (titleWidth < frame.size.width)
				point.x = frame.origin.x + frame.size.width - 
							(xDist + titleWidth);
      		else
				point.x = frame.origin.x + xDist;
      		break;
    	case NSCenterTextAlignment:
      		if (titleWidth < frame.size.width)
				point.x = frame.origin.x + (frame.size.width - titleWidth) / 2;
      		else
				point.x = frame.origin.x + xDist;
      		break;
  		}

	frame.origin.x = point.x;
				
	XRDrawString([contents cString], frame);			// draw the text
}

- (void)drawWithFrame:(NSRect)cellFrame inView:(NSView*)controlView
{
// 			We apply a clipping rectangle so save the graphics state
//  PSgsave();

	if (draw_background)								// Clear the cell frame
    	{
		[background_color set];
		NSRectFill(cellFrame);
    	}

	if (cell_bordered) 									// draw the border if 
		{												// needed.
		if (cell_bezeled) 
			{
			NSDrawGrayBezel (cellFrame, cellFrame);
			cellFrame.origin.x += 4;
			cellFrame.origin.y += 0;
			cellFrame.size.width -= 4;
			cellFrame.size.height -= 4;
    		}
		else 
			{
			NSFrameRect (cellFrame);
			cellFrame.origin.x += 1;
			cellFrame.origin.y += 1;
			cellFrame.size.width -= 2;
			cellFrame.size.height -= 2;
    		}
  		}

	[self drawInteriorWithFrame:cellFrame inView:controlView];

//  PSgrestore();
}

@end
